/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.Job;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeJobResponse> {
    private static final SdkField<String> DOCUMENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentSource").getter(DescribeJobResponse.getter(DescribeJobResponse::documentSource)).setter(DescribeJobResponse.setter(Builder::documentSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentSource").build()}).build();
    private static final SdkField<Job> JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("job").getter(DescribeJobResponse.getter(DescribeJobResponse::job)).setter(DescribeJobResponse.setter(Builder::job)).constructor(Job::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("job").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_SOURCE_FIELD, JOB_FIELD));
    private final String documentSource;
    private final Job job;

    private DescribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.documentSource = builder.documentSource;
        this.job = builder.job;
    }

    public String documentSource() {
        return this.documentSource;
    }

    public Job job() {
        return this.job;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.job());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse)((Object)obj);
        return Objects.equals(this.documentSource(), other.documentSource()) && Objects.equals(this.job(), other.job());
    }

    public String toString() {
        return ToString.builder((String)"DescribeJobResponse").add("DocumentSource", (Object)this.documentSource()).add("Job", (Object)this.job()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "documentSource": {
                return Optional.ofNullable(clazz.cast(this.documentSource()));
            }
            case "job": {
                return Optional.ofNullable(clazz.cast(this.job()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobResponse, T> g) {
        return obj -> g.apply((DescribeJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String documentSource;
        private Job job;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            super(model);
            this.documentSource(model.documentSource);
            this.job(model.job);
        }

        public final String getDocumentSource() {
            return this.documentSource;
        }

        @Override
        public final Builder documentSource(String documentSource) {
            this.documentSource = documentSource;
            return this;
        }

        public final void setDocumentSource(String documentSource) {
            this.documentSource = documentSource;
        }

        public final Job.Builder getJob() {
            return this.job != null ? this.job.toBuilder() : null;
        }

        @Override
        public final Builder job(Job job) {
            this.job = job;
            return this;
        }

        public final void setJob(Job.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        @Override
        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJobResponse> {
        public Builder documentSource(String var1);

        public Builder job(Job var1);

        default public Builder job(Consumer<Job.Builder> job) {
            return this.job((Job)((Job.Builder)Job.builder().applyMutation(job)).build());
        }
    }
}

