/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceIdentifier> {
    private static final SdkField<String> DEVICE_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceIdentifier.getter(ResourceIdentifier::deviceCertificateId)).setter(ResourceIdentifier.setter(Builder::deviceCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCertificateId").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceIdentifier.getter(ResourceIdentifier::caCertificateId)).setter(ResourceIdentifier.setter(Builder::caCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificateId").build()}).build();
    private static final SdkField<String> COGNITO_IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceIdentifier.getter(ResourceIdentifier::cognitoIdentityPoolId)).setter(ResourceIdentifier.setter(Builder::cognitoIdentityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoIdentityPoolId").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceIdentifier.getter(ResourceIdentifier::clientId)).setter(ResourceIdentifier.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<PolicyVersionIdentifier> POLICY_VERSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceIdentifier.getter(ResourceIdentifier::policyVersionIdentifier)).setter(ResourceIdentifier.setter(Builder::policyVersionIdentifier)).constructor(PolicyVersionIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersionIdentifier").build()}).build();
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceIdentifier.getter(ResourceIdentifier::account)).setter(ResourceIdentifier.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceIdentifier.getter(ResourceIdentifier::iamRoleArn)).setter(ResourceIdentifier.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()}).build();
    private static final SdkField<String> ROLE_ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceIdentifier.getter(ResourceIdentifier::roleAliasArn)).setter(ResourceIdentifier.setter(Builder::roleAliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAliasArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_CERTIFICATE_ID_FIELD, CA_CERTIFICATE_ID_FIELD, COGNITO_IDENTITY_POOL_ID_FIELD, CLIENT_ID_FIELD, POLICY_VERSION_IDENTIFIER_FIELD, ACCOUNT_FIELD, IAM_ROLE_ARN_FIELD, ROLE_ALIAS_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceCertificateId;
    private final String caCertificateId;
    private final String cognitoIdentityPoolId;
    private final String clientId;
    private final PolicyVersionIdentifier policyVersionIdentifier;
    private final String account;
    private final String iamRoleArn;
    private final String roleAliasArn;

    private ResourceIdentifier(BuilderImpl builder) {
        this.deviceCertificateId = builder.deviceCertificateId;
        this.caCertificateId = builder.caCertificateId;
        this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
        this.clientId = builder.clientId;
        this.policyVersionIdentifier = builder.policyVersionIdentifier;
        this.account = builder.account;
        this.iamRoleArn = builder.iamRoleArn;
        this.roleAliasArn = builder.roleAliasArn;
    }

    public String deviceCertificateId() {
        return this.deviceCertificateId;
    }

    public String caCertificateId() {
        return this.caCertificateId;
    }

    public String cognitoIdentityPoolId() {
        return this.cognitoIdentityPoolId;
    }

    public String clientId() {
        return this.clientId;
    }

    public PolicyVersionIdentifier policyVersionIdentifier() {
        return this.policyVersionIdentifier;
    }

    public String account() {
        return this.account;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public String roleAliasArn() {
        return this.roleAliasArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAliasArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        return Objects.equals(this.deviceCertificateId(), other.deviceCertificateId()) && Objects.equals(this.caCertificateId(), other.caCertificateId()) && Objects.equals(this.cognitoIdentityPoolId(), other.cognitoIdentityPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.policyVersionIdentifier(), other.policyVersionIdentifier()) && Objects.equals(this.account(), other.account()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.roleAliasArn(), other.roleAliasArn());
    }

    public String toString() {
        return ToString.builder((String)"ResourceIdentifier").add("DeviceCertificateId", (Object)this.deviceCertificateId()).add("CaCertificateId", (Object)this.caCertificateId()).add("CognitoIdentityPoolId", (Object)this.cognitoIdentityPoolId()).add("ClientId", (Object)this.clientId()).add("PolicyVersionIdentifier", (Object)this.policyVersionIdentifier()).add("Account", (Object)this.account()).add("IamRoleArn", (Object)this.iamRoleArn()).add("RoleAliasArn", (Object)this.roleAliasArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceCertificateId": {
                return Optional.ofNullable(clazz.cast(this.deviceCertificateId()));
            }
            case "caCertificateId": {
                return Optional.ofNullable(clazz.cast(this.caCertificateId()));
            }
            case "cognitoIdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.cognitoIdentityPoolId()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "policyVersionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.policyVersionIdentifier()));
            }
            case "account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "iamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "roleAliasArn": {
                return Optional.ofNullable(clazz.cast(this.roleAliasArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdentifier, T> g) {
        return obj -> g.apply((ResourceIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceCertificateId;
        private String caCertificateId;
        private String cognitoIdentityPoolId;
        private String clientId;
        private PolicyVersionIdentifier policyVersionIdentifier;
        private String account;
        private String iamRoleArn;
        private String roleAliasArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            this.deviceCertificateId(model.deviceCertificateId);
            this.caCertificateId(model.caCertificateId);
            this.cognitoIdentityPoolId(model.cognitoIdentityPoolId);
            this.clientId(model.clientId);
            this.policyVersionIdentifier(model.policyVersionIdentifier);
            this.account(model.account);
            this.iamRoleArn(model.iamRoleArn);
            this.roleAliasArn(model.roleAliasArn);
        }

        public final String getDeviceCertificateId() {
            return this.deviceCertificateId;
        }

        @Override
        public final Builder deviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
            return this;
        }

        public final void setDeviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
        }

        public final String getCaCertificateId() {
            return this.caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final String getCognitoIdentityPoolId() {
            return this.cognitoIdentityPoolId;
        }

        @Override
        public final Builder cognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        public final void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final PolicyVersionIdentifier.Builder getPolicyVersionIdentifier() {
            return this.policyVersionIdentifier != null ? this.policyVersionIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder policyVersionIdentifier(PolicyVersionIdentifier policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier;
            return this;
        }

        public final void setPolicyVersionIdentifier(PolicyVersionIdentifier.BuilderImpl policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier != null ? policyVersionIdentifier.build() : null;
        }

        public final String getAccount() {
            return this.account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getRoleAliasArn() {
            return this.roleAliasArn;
        }

        @Override
        public final Builder roleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
            return this;
        }

        public final void setRoleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
        }

        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceIdentifier> {
        public Builder deviceCertificateId(String var1);

        public Builder caCertificateId(String var1);

        public Builder cognitoIdentityPoolId(String var1);

        public Builder clientId(String var1);

        public Builder policyVersionIdentifier(PolicyVersionIdentifier var1);

        default public Builder policyVersionIdentifier(Consumer<PolicyVersionIdentifier.Builder> policyVersionIdentifier) {
            return this.policyVersionIdentifier((PolicyVersionIdentifier)((PolicyVersionIdentifier.Builder)PolicyVersionIdentifier.builder().applyMutation(policyVersionIdentifier)).build());
        }

        public Builder account(String var1);

        public Builder iamRoleArn(String var1);

        public Builder roleAliasArn(String var1);
    }
}

