/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.internetmonitor.model.HealthEventsConfig;
import software.amazon.awssdk.services.internetmonitor.model.InternetMeasurementsLogDelivery;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.SetOfARNsCopier;
import software.amazon.awssdk.services.internetmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMonitorRequest
extends InternetMonitorRequest
implements ToCopyableBuilder<Builder, CreateMonitorRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorName").getter(CreateMonitorRequest.getter(CreateMonitorRequest::monitorName)).setter(CreateMonitorRequest.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()}).build();
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(CreateMonitorRequest.getter(CreateMonitorRequest::resources)).setter(CreateMonitorRequest.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateMonitorRequest.getter(CreateMonitorRequest::clientToken)).setter(CreateMonitorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateMonitorRequest.getter(CreateMonitorRequest::tags)).setter(CreateMonitorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_CITY_NETWORKS_TO_MONITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCityNetworksToMonitor").getter(CreateMonitorRequest.getter(CreateMonitorRequest::maxCityNetworksToMonitor)).setter(CreateMonitorRequest.setter(Builder::maxCityNetworksToMonitor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCityNetworksToMonitor").build()}).build();
    private static final SdkField<InternetMeasurementsLogDelivery> INTERNET_MEASUREMENTS_LOG_DELIVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InternetMeasurementsLogDelivery").getter(CreateMonitorRequest.getter(CreateMonitorRequest::internetMeasurementsLogDelivery)).setter(CreateMonitorRequest.setter(Builder::internetMeasurementsLogDelivery)).constructor(InternetMeasurementsLogDelivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetMeasurementsLogDelivery").build()}).build();
    private static final SdkField<Integer> TRAFFIC_PERCENTAGE_TO_MONITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TrafficPercentageToMonitor").getter(CreateMonitorRequest.getter(CreateMonitorRequest::trafficPercentageToMonitor)).setter(CreateMonitorRequest.setter(Builder::trafficPercentageToMonitor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPercentageToMonitor").build()}).build();
    private static final SdkField<HealthEventsConfig> HEALTH_EVENTS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthEventsConfig").getter(CreateMonitorRequest.getter(CreateMonitorRequest::healthEventsConfig)).setter(CreateMonitorRequest.setter(Builder::healthEventsConfig)).constructor(HealthEventsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, RESOURCES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, MAX_CITY_NETWORKS_TO_MONITOR_FIELD, INTERNET_MEASUREMENTS_LOG_DELIVERY_FIELD, TRAFFIC_PERCENTAGE_TO_MONITOR_FIELD, HEALTH_EVENTS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMonitorRequest.memberNameToFieldInitializer();
    private final String monitorName;
    private final List<String> resources;
    private final String clientToken;
    private final Map<String, String> tags;
    private final Integer maxCityNetworksToMonitor;
    private final InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;
    private final Integer trafficPercentageToMonitor;
    private final HealthEventsConfig healthEventsConfig;

    private CreateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.resources = builder.resources;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.maxCityNetworksToMonitor = builder.maxCityNetworksToMonitor;
        this.internetMeasurementsLogDelivery = builder.internetMeasurementsLogDelivery;
        this.trafficPercentageToMonitor = builder.trafficPercentageToMonitor;
        this.healthEventsConfig = builder.healthEventsConfig;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<String> resources() {
        return this.resources;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer maxCityNetworksToMonitor() {
        return this.maxCityNetworksToMonitor;
    }

    public final InternetMeasurementsLogDelivery internetMeasurementsLogDelivery() {
        return this.internetMeasurementsLogDelivery;
    }

    public final Integer trafficPercentageToMonitor() {
        return this.trafficPercentageToMonitor;
    }

    public final HealthEventsConfig healthEventsConfig() {
        return this.healthEventsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCityNetworksToMonitor());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetMeasurementsLogDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPercentageToMonitor());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthEventsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorRequest)) {
            return false;
        }
        CreateMonitorRequest other = (CreateMonitorRequest)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.maxCityNetworksToMonitor(), other.maxCityNetworksToMonitor()) && Objects.equals(this.internetMeasurementsLogDelivery(), other.internetMeasurementsLogDelivery()) && Objects.equals(this.trafficPercentageToMonitor(), other.trafficPercentageToMonitor()) && Objects.equals(this.healthEventsConfig(), other.healthEventsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMonitorRequest").add("MonitorName", (Object)this.monitorName()).add("Resources", this.hasResources() ? this.resources() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("MaxCityNetworksToMonitor", (Object)this.maxCityNetworksToMonitor()).add("InternetMeasurementsLogDelivery", (Object)this.internetMeasurementsLogDelivery()).add("TrafficPercentageToMonitor", (Object)this.trafficPercentageToMonitor()).add("HealthEventsConfig", (Object)this.healthEventsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "MaxCityNetworksToMonitor": {
                return Optional.ofNullable(clazz.cast(this.maxCityNetworksToMonitor()));
            }
            case "InternetMeasurementsLogDelivery": {
                return Optional.ofNullable(clazz.cast(this.internetMeasurementsLogDelivery()));
            }
            case "TrafficPercentageToMonitor": {
                return Optional.ofNullable(clazz.cast(this.trafficPercentageToMonitor()));
            }
            case "HealthEventsConfig": {
                return Optional.ofNullable(clazz.cast(this.healthEventsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MonitorName", MONITOR_NAME_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("MaxCityNetworksToMonitor", MAX_CITY_NETWORKS_TO_MONITOR_FIELD);
        map.put("InternetMeasurementsLogDelivery", INTERNET_MEASUREMENTS_LOG_DELIVERY_FIELD);
        map.put("TrafficPercentageToMonitor", TRAFFIC_PERCENTAGE_TO_MONITOR_FIELD);
        map.put("HealthEventsConfig", HEALTH_EVENTS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitorRequest, T> g) {
        return obj -> g.apply((CreateMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorRequest.BuilderImpl
    implements Builder {
        private String monitorName;
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxCityNetworksToMonitor;
        private InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;
        private Integer trafficPercentageToMonitor;
        private HealthEventsConfig healthEventsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitorRequest model) {
            super(model);
            this.monitorName(model.monitorName);
            this.resources(model.resources);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.maxCityNetworksToMonitor(model.maxCityNetworksToMonitor);
            this.internetMeasurementsLogDelivery(model.internetMeasurementsLogDelivery);
            this.trafficPercentageToMonitor(model.trafficPercentageToMonitor);
            this.healthEventsConfig(model.healthEventsConfig);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final Collection<String> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = SetOfARNsCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = SetOfARNsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Integer getMaxCityNetworksToMonitor() {
            return this.maxCityNetworksToMonitor;
        }

        public final void setMaxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
            this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
        }

        @Override
        public final Builder maxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
            this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
            return this;
        }

        public final InternetMeasurementsLogDelivery.Builder getInternetMeasurementsLogDelivery() {
            return this.internetMeasurementsLogDelivery != null ? this.internetMeasurementsLogDelivery.toBuilder() : null;
        }

        public final void setInternetMeasurementsLogDelivery(InternetMeasurementsLogDelivery.BuilderImpl internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery != null ? internetMeasurementsLogDelivery.build() : null;
        }

        @Override
        public final Builder internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery;
            return this;
        }

        public final Integer getTrafficPercentageToMonitor() {
            return this.trafficPercentageToMonitor;
        }

        public final void setTrafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
            this.trafficPercentageToMonitor = trafficPercentageToMonitor;
        }

        @Override
        public final Builder trafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
            this.trafficPercentageToMonitor = trafficPercentageToMonitor;
            return this;
        }

        public final HealthEventsConfig.Builder getHealthEventsConfig() {
            return this.healthEventsConfig != null ? this.healthEventsConfig.toBuilder() : null;
        }

        public final void setHealthEventsConfig(HealthEventsConfig.BuilderImpl healthEventsConfig) {
            this.healthEventsConfig = healthEventsConfig != null ? healthEventsConfig.build() : null;
        }

        @Override
        public final Builder healthEventsConfig(HealthEventsConfig healthEventsConfig) {
            this.healthEventsConfig = healthEventsConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMonitorRequest build() {
            return new CreateMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InternetMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMonitorRequest> {
        public Builder monitorName(String var1);

        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder maxCityNetworksToMonitor(Integer var1);

        public Builder internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery var1);

        default public Builder internetMeasurementsLogDelivery(Consumer<InternetMeasurementsLogDelivery.Builder> internetMeasurementsLogDelivery) {
            return this.internetMeasurementsLogDelivery((InternetMeasurementsLogDelivery)((InternetMeasurementsLogDelivery.Builder)InternetMeasurementsLogDelivery.builder().applyMutation(internetMeasurementsLogDelivery)).build());
        }

        public Builder trafficPercentageToMonitor(Integer var1);

        public Builder healthEventsConfig(HealthEventsConfig var1);

        default public Builder healthEventsConfig(Consumer<HealthEventsConfig.Builder> healthEventsConfig) {
            return this.healthEventsConfig((HealthEventsConfig)((HealthEventsConfig.Builder)HealthEventsConfig.builder().applyMutation(healthEventsConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

