/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorAsyncClient;
import software.amazon.awssdk.services.internetmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.internetmonitor.model.HealthEvent;
import software.amazon.awssdk.services.internetmonitor.model.ListHealthEventsRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListHealthEventsResponse;

public class ListHealthEventsPublisher
implements SdkPublisher<ListHealthEventsResponse> {
    private final InternetMonitorAsyncClient client;
    private final ListHealthEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHealthEventsPublisher(InternetMonitorAsyncClient client, ListHealthEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHealthEventsPublisher(InternetMonitorAsyncClient client, ListHealthEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHealthEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHealthEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HealthEvent> healthEvents() {
        Function<ListHealthEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.healthEvents() != null) {
                return response.healthEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListHealthEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListHealthEventsResponseFetcher
    implements AsyncPageFetcher<ListHealthEventsResponse> {
        private ListHealthEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListHealthEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHealthEventsResponse> nextPage(ListHealthEventsResponse previousPage) {
            if (previousPage == null) {
                return ListHealthEventsPublisher.this.client.listHealthEvents(ListHealthEventsPublisher.this.firstRequest);
            }
            return ListHealthEventsPublisher.this.client.listHealthEvents((ListHealthEventsRequest)((Object)ListHealthEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

