/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorClient;
import software.amazon.awssdk.services.internetmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.internetmonitor.model.InternetEventSummary;
import software.amazon.awssdk.services.internetmonitor.model.ListInternetEventsRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListInternetEventsResponse;

public class ListInternetEventsIterable
implements SdkIterable<ListInternetEventsResponse> {
    private final InternetMonitorClient client;
    private final ListInternetEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInternetEventsIterable(InternetMonitorClient client, ListInternetEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInternetEventsResponseFetcher();
    }

    public Iterator<ListInternetEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InternetEventSummary> internetEvents() {
        Function<ListInternetEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.internetEvents() != null) {
                return response.internetEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInternetEventsResponseFetcher
    implements SyncPageFetcher<ListInternetEventsResponse> {
        private ListInternetEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListInternetEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInternetEventsResponse nextPage(ListInternetEventsResponse previousPage) {
            if (previousPage == null) {
                return ListInternetEventsIterable.this.client.listInternetEvents(ListInternetEventsIterable.this.firstRequest);
            }
            return ListInternetEventsIterable.this.client.listInternetEvents((ListInternetEventsRequest)((Object)ListInternetEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

