/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.internetmonitor.model.HealthEvent;
import software.amazon.awssdk.services.internetmonitor.model.HealthEventListCopier;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHealthEventsResponse
extends InternetMonitorResponse
implements ToCopyableBuilder<Builder, ListHealthEventsResponse> {
    private static final SdkField<List<HealthEvent>> HEALTH_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HealthEvents").getter(ListHealthEventsResponse.getter(ListHealthEventsResponse::healthEvents)).setter(ListHealthEventsResponse.setter(Builder::healthEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HealthEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHealthEventsResponse.getter(ListHealthEventsResponse::nextToken)).setter(ListHealthEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListHealthEventsResponse.memberNameToFieldInitializer();
    private final List<HealthEvent> healthEvents;
    private final String nextToken;

    private ListHealthEventsResponse(BuilderImpl builder) {
        super(builder);
        this.healthEvents = builder.healthEvents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHealthEvents() {
        return this.healthEvents != null && !(this.healthEvents instanceof SdkAutoConstructList);
    }

    public final List<HealthEvent> healthEvents() {
        return this.healthEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHealthEvents() ? this.healthEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthEventsResponse)) {
            return false;
        }
        ListHealthEventsResponse other = (ListHealthEventsResponse)((Object)obj);
        return this.hasHealthEvents() == other.hasHealthEvents() && Objects.equals(this.healthEvents(), other.healthEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHealthEventsResponse").add("HealthEvents", this.hasHealthEvents() ? this.healthEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HealthEvents": {
                return Optional.ofNullable(clazz.cast(this.healthEvents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HealthEvents", HEALTH_EVENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHealthEventsResponse, T> g) {
        return obj -> g.apply((ListHealthEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorResponse.BuilderImpl
    implements Builder {
        private List<HealthEvent> healthEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHealthEventsResponse model) {
            super(model);
            this.healthEvents(model.healthEvents);
            this.nextToken(model.nextToken);
        }

        public final List<HealthEvent.Builder> getHealthEvents() {
            List<HealthEvent.Builder> result = HealthEventListCopier.copyToBuilder(this.healthEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHealthEvents(Collection<HealthEvent.BuilderImpl> healthEvents) {
            this.healthEvents = HealthEventListCopier.copyFromBuilder(healthEvents);
        }

        @Override
        public final Builder healthEvents(Collection<HealthEvent> healthEvents) {
            this.healthEvents = HealthEventListCopier.copy(healthEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthEvents(HealthEvent ... healthEvents) {
            this.healthEvents(Arrays.asList(healthEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthEvents(Consumer<HealthEvent.Builder> ... healthEvents) {
            this.healthEvents(Stream.of(healthEvents).map(c -> (HealthEvent)((HealthEvent.Builder)HealthEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHealthEventsResponse build() {
            return new ListHealthEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InternetMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHealthEventsResponse> {
        public Builder healthEvents(Collection<HealthEvent> var1);

        public Builder healthEvents(HealthEvent ... var1);

        public Builder healthEvents(Consumer<HealthEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

