/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorClient;
import software.amazon.awssdk.services.internetmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.internetmonitor.model.HealthEvent;
import software.amazon.awssdk.services.internetmonitor.model.ListHealthEventsRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListHealthEventsResponse;

public class ListHealthEventsIterable
implements SdkIterable<ListHealthEventsResponse> {
    private final InternetMonitorClient client;
    private final ListHealthEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHealthEventsIterable(InternetMonitorClient client, ListHealthEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHealthEventsResponseFetcher();
    }

    public Iterator<ListHealthEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HealthEvent> healthEvents() {
        Function<ListHealthEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.healthEvents() != null) {
                return response.healthEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHealthEventsResponseFetcher
    implements SyncPageFetcher<ListHealthEventsResponse> {
        private ListHealthEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListHealthEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHealthEventsResponse nextPage(ListHealthEventsResponse previousPage) {
            if (previousPage == null) {
                return ListHealthEventsIterable.this.client.listHealthEvents(ListHealthEventsIterable.this.firstRequest);
            }
            return ListHealthEventsIterable.this.client.listHealthEvents((ListHealthEventsRequest)((Object)ListHealthEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

