/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorAsyncClient;
import software.amazon.awssdk.services.internetmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.internetmonitor.model.InternetEventSummary;
import software.amazon.awssdk.services.internetmonitor.model.ListInternetEventsRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListInternetEventsResponse;

public class ListInternetEventsPublisher
implements SdkPublisher<ListInternetEventsResponse> {
    private final InternetMonitorAsyncClient client;
    private final ListInternetEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInternetEventsPublisher(InternetMonitorAsyncClient client, ListInternetEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInternetEventsPublisher(InternetMonitorAsyncClient client, ListInternetEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInternetEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInternetEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InternetEventSummary> internetEvents() {
        Function<ListInternetEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.internetEvents() != null) {
                return response.internetEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInternetEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInternetEventsResponseFetcher
    implements AsyncPageFetcher<ListInternetEventsResponse> {
        private ListInternetEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListInternetEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInternetEventsResponse> nextPage(ListInternetEventsResponse previousPage) {
            if (previousPage == null) {
                return ListInternetEventsPublisher.this.client.listInternetEvents(ListInternetEventsPublisher.this.firstRequest);
            }
            return ListInternetEventsPublisher.this.client.listInternetEvents((ListInternetEventsRequest)((Object)ListInternetEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

