/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.internetmonitor.model.HealthEventStatus;
import software.amazon.awssdk.services.internetmonitor.model.InternetHealth;
import software.amazon.awssdk.services.internetmonitor.model.Ipv4PrefixListCopier;
import software.amazon.awssdk.services.internetmonitor.model.NetworkImpairment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImpactedLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImpactedLocation> {
    private static final SdkField<String> AS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ASName").getter(ImpactedLocation.getter(ImpactedLocation::asName)).setter(ImpactedLocation.setter(Builder::asName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASName").build()}).build();
    private static final SdkField<Long> AS_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ASNumber").getter(ImpactedLocation.getter(ImpactedLocation::asNumber)).setter(ImpactedLocation.setter(Builder::asNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASNumber").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(ImpactedLocation.getter(ImpactedLocation::country)).setter(ImpactedLocation.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> SUBDIVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdivision").getter(ImpactedLocation.getter(ImpactedLocation::subdivision)).setter(ImpactedLocation.setter(Builder::subdivision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdivision").build()}).build();
    private static final SdkField<String> METRO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metro").getter(ImpactedLocation.getter(ImpactedLocation::metro)).setter(ImpactedLocation.setter(Builder::metro)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metro").build()}).build();
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("City").getter(ImpactedLocation.getter(ImpactedLocation::city)).setter(ImpactedLocation.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()}).build();
    private static final SdkField<Double> LATITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Latitude").getter(ImpactedLocation.getter(ImpactedLocation::latitude)).setter(ImpactedLocation.setter(Builder::latitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latitude").build()}).build();
    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Longitude").getter(ImpactedLocation.getter(ImpactedLocation::longitude)).setter(ImpactedLocation.setter(Builder::longitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Longitude").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryCode").getter(ImpactedLocation.getter(ImpactedLocation::countryCode)).setter(ImpactedLocation.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()}).build();
    private static final SdkField<String> SUBDIVISION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubdivisionCode").getter(ImpactedLocation.getter(ImpactedLocation::subdivisionCode)).setter(ImpactedLocation.setter(Builder::subdivisionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubdivisionCode").build()}).build();
    private static final SdkField<String> SERVICE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceLocation").getter(ImpactedLocation.getter(ImpactedLocation::serviceLocation)).setter(ImpactedLocation.setter(Builder::serviceLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLocation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ImpactedLocation.getter(ImpactedLocation::statusAsString)).setter(ImpactedLocation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<NetworkImpairment> CAUSED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CausedBy").getter(ImpactedLocation.getter(ImpactedLocation::causedBy)).setter(ImpactedLocation.setter(Builder::causedBy)).constructor(NetworkImpairment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CausedBy").build()}).build();
    private static final SdkField<InternetHealth> INTERNET_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InternetHealth").getter(ImpactedLocation.getter(ImpactedLocation::internetHealth)).setter(ImpactedLocation.setter(Builder::internetHealth)).constructor(InternetHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetHealth").build()}).build();
    private static final SdkField<List<String>> IPV4_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv4Prefixes").getter(ImpactedLocation.getter(ImpactedLocation::ipv4Prefixes)).setter(ImpactedLocation.setter(Builder::ipv4Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AS_NAME_FIELD, AS_NUMBER_FIELD, COUNTRY_FIELD, SUBDIVISION_FIELD, METRO_FIELD, CITY_FIELD, LATITUDE_FIELD, LONGITUDE_FIELD, COUNTRY_CODE_FIELD, SUBDIVISION_CODE_FIELD, SERVICE_LOCATION_FIELD, STATUS_FIELD, CAUSED_BY_FIELD, INTERNET_HEALTH_FIELD, IPV4_PREFIXES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String asName;
    private final Long asNumber;
    private final String country;
    private final String subdivision;
    private final String metro;
    private final String city;
    private final Double latitude;
    private final Double longitude;
    private final String countryCode;
    private final String subdivisionCode;
    private final String serviceLocation;
    private final String status;
    private final NetworkImpairment causedBy;
    private final InternetHealth internetHealth;
    private final List<String> ipv4Prefixes;

    private ImpactedLocation(BuilderImpl builder) {
        this.asName = builder.asName;
        this.asNumber = builder.asNumber;
        this.country = builder.country;
        this.subdivision = builder.subdivision;
        this.metro = builder.metro;
        this.city = builder.city;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
        this.countryCode = builder.countryCode;
        this.subdivisionCode = builder.subdivisionCode;
        this.serviceLocation = builder.serviceLocation;
        this.status = builder.status;
        this.causedBy = builder.causedBy;
        this.internetHealth = builder.internetHealth;
        this.ipv4Prefixes = builder.ipv4Prefixes;
    }

    public final String asName() {
        return this.asName;
    }

    public final Long asNumber() {
        return this.asNumber;
    }

    public final String country() {
        return this.country;
    }

    public final String subdivision() {
        return this.subdivision;
    }

    public final String metro() {
        return this.metro;
    }

    public final String city() {
        return this.city;
    }

    public final Double latitude() {
        return this.latitude;
    }

    public final Double longitude() {
        return this.longitude;
    }

    public final String countryCode() {
        return this.countryCode;
    }

    public final String subdivisionCode() {
        return this.subdivisionCode;
    }

    public final String serviceLocation() {
        return this.serviceLocation;
    }

    public final HealthEventStatus status() {
        return HealthEventStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final NetworkImpairment causedBy() {
        return this.causedBy;
    }

    public final InternetHealth internetHealth() {
        return this.internetHealth;
    }

    public final boolean hasIpv4Prefixes() {
        return this.ipv4Prefixes != null && !(this.ipv4Prefixes instanceof SdkAutoConstructList);
    }

    public final List<String> ipv4Prefixes() {
        return this.ipv4Prefixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.asName());
        hashCode = 31 * hashCode + Objects.hashCode(this.asNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdivision());
        hashCode = 31 * hashCode + Objects.hashCode(this.metro());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.latitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.longitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.causedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetHealth());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImpactedLocation)) {
            return false;
        }
        ImpactedLocation other = (ImpactedLocation)obj;
        return Objects.equals(this.asName(), other.asName()) && Objects.equals(this.asNumber(), other.asNumber()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.subdivision(), other.subdivision()) && Objects.equals(this.metro(), other.metro()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.latitude(), other.latitude()) && Objects.equals(this.longitude(), other.longitude()) && Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.subdivisionCode(), other.subdivisionCode()) && Objects.equals(this.serviceLocation(), other.serviceLocation()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.causedBy(), other.causedBy()) && Objects.equals(this.internetHealth(), other.internetHealth()) && this.hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(this.ipv4Prefixes(), other.ipv4Prefixes());
    }

    public final String toString() {
        return ToString.builder((String)"ImpactedLocation").add("ASName", (Object)this.asName()).add("ASNumber", (Object)this.asNumber()).add("Country", (Object)this.country()).add("Subdivision", (Object)this.subdivision()).add("Metro", (Object)this.metro()).add("City", (Object)this.city()).add("Latitude", (Object)this.latitude()).add("Longitude", (Object)this.longitude()).add("CountryCode", (Object)this.countryCode()).add("SubdivisionCode", (Object)this.subdivisionCode()).add("ServiceLocation", (Object)this.serviceLocation()).add("Status", (Object)this.statusAsString()).add("CausedBy", (Object)this.causedBy()).add("InternetHealth", (Object)this.internetHealth()).add("Ipv4Prefixes", this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ASName": {
                return Optional.ofNullable(clazz.cast(this.asName()));
            }
            case "ASNumber": {
                return Optional.ofNullable(clazz.cast(this.asNumber()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Subdivision": {
                return Optional.ofNullable(clazz.cast(this.subdivision()));
            }
            case "Metro": {
                return Optional.ofNullable(clazz.cast(this.metro()));
            }
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "Latitude": {
                return Optional.ofNullable(clazz.cast(this.latitude()));
            }
            case "Longitude": {
                return Optional.ofNullable(clazz.cast(this.longitude()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "SubdivisionCode": {
                return Optional.ofNullable(clazz.cast(this.subdivisionCode()));
            }
            case "ServiceLocation": {
                return Optional.ofNullable(clazz.cast(this.serviceLocation()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CausedBy": {
                return Optional.ofNullable(clazz.cast(this.causedBy()));
            }
            case "InternetHealth": {
                return Optional.ofNullable(clazz.cast(this.internetHealth()));
            }
            case "Ipv4Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv4Prefixes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImpactedLocation, T> g) {
        return obj -> g.apply((ImpactedLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String asName;
        private Long asNumber;
        private String country;
        private String subdivision;
        private String metro;
        private String city;
        private Double latitude;
        private Double longitude;
        private String countryCode;
        private String subdivisionCode;
        private String serviceLocation;
        private String status;
        private NetworkImpairment causedBy;
        private InternetHealth internetHealth;
        private List<String> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImpactedLocation model) {
            this.asName(model.asName);
            this.asNumber(model.asNumber);
            this.country(model.country);
            this.subdivision(model.subdivision);
            this.metro(model.metro);
            this.city(model.city);
            this.latitude(model.latitude);
            this.longitude(model.longitude);
            this.countryCode(model.countryCode);
            this.subdivisionCode(model.subdivisionCode);
            this.serviceLocation(model.serviceLocation);
            this.status(model.status);
            this.causedBy(model.causedBy);
            this.internetHealth(model.internetHealth);
            this.ipv4Prefixes(model.ipv4Prefixes);
        }

        public final String getAsName() {
            return this.asName;
        }

        public final void setAsName(String asName) {
            this.asName = asName;
        }

        @Override
        public final Builder asName(String asName) {
            this.asName = asName;
            return this;
        }

        public final Long getAsNumber() {
            return this.asNumber;
        }

        public final void setAsNumber(Long asNumber) {
            this.asNumber = asNumber;
        }

        @Override
        public final Builder asNumber(Long asNumber) {
            this.asNumber = asNumber;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getSubdivision() {
            return this.subdivision;
        }

        public final void setSubdivision(String subdivision) {
            this.subdivision = subdivision;
        }

        @Override
        public final Builder subdivision(String subdivision) {
            this.subdivision = subdivision;
            return this;
        }

        public final String getMetro() {
            return this.metro;
        }

        public final void setMetro(String metro) {
            this.metro = metro;
        }

        @Override
        public final Builder metro(String metro) {
            this.metro = metro;
            return this;
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getSubdivisionCode() {
            return this.subdivisionCode;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public final String getServiceLocation() {
            return this.serviceLocation;
        }

        public final void setServiceLocation(String serviceLocation) {
            this.serviceLocation = serviceLocation;
        }

        @Override
        public final Builder serviceLocation(String serviceLocation) {
            this.serviceLocation = serviceLocation;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HealthEventStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final NetworkImpairment.Builder getCausedBy() {
            return this.causedBy != null ? this.causedBy.toBuilder() : null;
        }

        public final void setCausedBy(NetworkImpairment.BuilderImpl causedBy) {
            this.causedBy = causedBy != null ? causedBy.build() : null;
        }

        @Override
        public final Builder causedBy(NetworkImpairment causedBy) {
            this.causedBy = causedBy;
            return this;
        }

        public final InternetHealth.Builder getInternetHealth() {
            return this.internetHealth != null ? this.internetHealth.toBuilder() : null;
        }

        public final void setInternetHealth(InternetHealth.BuilderImpl internetHealth) {
            this.internetHealth = internetHealth != null ? internetHealth.build() : null;
        }

        @Override
        public final Builder internetHealth(InternetHealth internetHealth) {
            this.internetHealth = internetHealth;
            return this;
        }

        public final Collection<String> getIpv4Prefixes() {
            if (this.ipv4Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv4Prefixes;
        }

        public final void setIpv4Prefixes(Collection<String> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copy(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<String> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(String ... ipv4Prefixes) {
            this.ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        public ImpactedLocation build() {
            return new ImpactedLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImpactedLocation> {
        public Builder asName(String var1);

        public Builder asNumber(Long var1);

        public Builder country(String var1);

        public Builder subdivision(String var1);

        public Builder metro(String var1);

        public Builder city(String var1);

        public Builder latitude(Double var1);

        public Builder longitude(Double var1);

        public Builder countryCode(String var1);

        public Builder subdivisionCode(String var1);

        public Builder serviceLocation(String var1);

        public Builder status(String var1);

        public Builder status(HealthEventStatus var1);

        public Builder causedBy(NetworkImpairment var1);

        default public Builder causedBy(Consumer<NetworkImpairment.Builder> causedBy) {
            return this.causedBy((NetworkImpairment)((NetworkImpairment.Builder)NetworkImpairment.builder().applyMutation(causedBy)).build());
        }

        public Builder internetHealth(InternetHealth var1);

        default public Builder internetHealth(Consumer<InternetHealth.Builder> internetHealth) {
            return this.internetHealth((InternetHealth)((InternetHealth.Builder)InternetHealth.builder().applyMutation(internetHealth)).build());
        }

        public Builder ipv4Prefixes(Collection<String> var1);

        public Builder ipv4Prefixes(String ... var1);
    }
}

