/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorAsyncClient;
import software.amazon.awssdk.services.internetmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.internetmonitor.model.ListMonitorsRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListMonitorsResponse;
import software.amazon.awssdk.services.internetmonitor.model.Monitor;

public class ListMonitorsPublisher
implements SdkPublisher<ListMonitorsResponse> {
    private final InternetMonitorAsyncClient client;
    private final ListMonitorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMonitorsPublisher(InternetMonitorAsyncClient client, ListMonitorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMonitorsPublisher(InternetMonitorAsyncClient client, ListMonitorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMonitorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMonitorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Monitor> monitors() {
        Function<ListMonitorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitors() != null) {
                return response.monitors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMonitorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMonitorsResponseFetcher
    implements AsyncPageFetcher<ListMonitorsResponse> {
        private ListMonitorsResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMonitorsResponse> nextPage(ListMonitorsResponse previousPage) {
            if (previousPage == null) {
                return ListMonitorsPublisher.this.client.listMonitors(ListMonitorsPublisher.this.firstRequest);
            }
            return ListMonitorsPublisher.this.client.listMonitors((ListMonitorsRequest)((Object)ListMonitorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

