/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type for the configuration. Defines the health event threshold percentages, for performance score and
 * availability score. Amazon CloudWatch Internet Monitor creates a health event when there's an internet issue that
 * affects your application end users where a health score percentage is at or below a set threshold. If you don't set a
 * health event threshold, the default value is 95%.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthEventsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HealthEventsConfig.Builder, HealthEventsConfig> {
    private static final SdkField<Double> AVAILABILITY_SCORE_THRESHOLD_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("AvailabilityScoreThreshold")
            .getter(getter(HealthEventsConfig::availabilityScoreThreshold))
            .setter(setter(Builder::availabilityScoreThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityScoreThreshold").build())
            .build();

    private static final SdkField<Double> PERFORMANCE_SCORE_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("PerformanceScoreThreshold").getter(getter(HealthEventsConfig::performanceScoreThreshold))
            .setter(setter(Builder::performanceScoreThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceScoreThreshold").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AVAILABILITY_SCORE_THRESHOLD_FIELD, PERFORMANCE_SCORE_THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double availabilityScoreThreshold;

    private final Double performanceScoreThreshold;

    private HealthEventsConfig(BuilderImpl builder) {
        this.availabilityScoreThreshold = builder.availabilityScoreThreshold;
        this.performanceScoreThreshold = builder.performanceScoreThreshold;
    }

    /**
     * <p>
     * The health event threshold percentage set for availability scores.
     * </p>
     * 
     * @return The health event threshold percentage set for availability scores.
     */
    public final Double availabilityScoreThreshold() {
        return availabilityScoreThreshold;
    }

    /**
     * <p>
     * The health event threshold percentage set for performance scores.
     * </p>
     * 
     * @return The health event threshold percentage set for performance scores.
     */
    public final Double performanceScoreThreshold() {
        return performanceScoreThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityScoreThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(performanceScoreThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthEventsConfig)) {
            return false;
        }
        HealthEventsConfig other = (HealthEventsConfig) obj;
        return Objects.equals(availabilityScoreThreshold(), other.availabilityScoreThreshold())
                && Objects.equals(performanceScoreThreshold(), other.performanceScoreThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HealthEventsConfig").add("AvailabilityScoreThreshold", availabilityScoreThreshold())
                .add("PerformanceScoreThreshold", performanceScoreThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityScoreThreshold":
            return Optional.ofNullable(clazz.cast(availabilityScoreThreshold()));
        case "PerformanceScoreThreshold":
            return Optional.ofNullable(clazz.cast(performanceScoreThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthEventsConfig, T> g) {
        return obj -> g.apply((HealthEventsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthEventsConfig> {
        /**
         * <p>
         * The health event threshold percentage set for availability scores.
         * </p>
         * 
         * @param availabilityScoreThreshold
         *        The health event threshold percentage set for availability scores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityScoreThreshold(Double availabilityScoreThreshold);

        /**
         * <p>
         * The health event threshold percentage set for performance scores.
         * </p>
         * 
         * @param performanceScoreThreshold
         *        The health event threshold percentage set for performance scores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceScoreThreshold(Double performanceScoreThreshold);
    }

    static final class BuilderImpl implements Builder {
        private Double availabilityScoreThreshold;

        private Double performanceScoreThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthEventsConfig model) {
            availabilityScoreThreshold(model.availabilityScoreThreshold);
            performanceScoreThreshold(model.performanceScoreThreshold);
        }

        public final Double getAvailabilityScoreThreshold() {
            return availabilityScoreThreshold;
        }

        public final void setAvailabilityScoreThreshold(Double availabilityScoreThreshold) {
            this.availabilityScoreThreshold = availabilityScoreThreshold;
        }

        @Override
        public final Builder availabilityScoreThreshold(Double availabilityScoreThreshold) {
            this.availabilityScoreThreshold = availabilityScoreThreshold;
            return this;
        }

        public final Double getPerformanceScoreThreshold() {
            return performanceScoreThreshold;
        }

        public final void setPerformanceScoreThreshold(Double performanceScoreThreshold) {
            this.performanceScoreThreshold = performanceScoreThreshold;
        }

        @Override
        public final Builder performanceScoreThreshold(Double performanceScoreThreshold) {
            this.performanceScoreThreshold = performanceScoreThreshold;
            return this;
        }

        @Override
        public HealthEventsConfig build() {
            return new HealthEventsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
