/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMonitorResponse extends InternetMonitorResponse implements
        ToCopyableBuilder<GetMonitorResponse.Builder, GetMonitorResponse> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorName").getter(getter(GetMonitorResponse::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()).build();

    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorArn").getter(getter(GetMonitorResponse::monitorArn)).setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()).build();

    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(GetMonitorResponse::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetMonitorResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetMonitorResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt")
            .getter(getter(GetMonitorResponse::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PROCESSING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProcessingStatus").getter(getter(GetMonitorResponse::processingStatusAsString))
            .setter(setter(Builder::processingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatus").build()).build();

    private static final SdkField<String> PROCESSING_STATUS_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProcessingStatusInfo").getter(getter(GetMonitorResponse::processingStatusInfo))
            .setter(setter(Builder::processingStatusInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatusInfo").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetMonitorResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_CITY_NETWORKS_TO_MONITOR_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxCityNetworksToMonitor")
            .getter(getter(GetMonitorResponse::maxCityNetworksToMonitor)).setter(setter(Builder::maxCityNetworksToMonitor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCityNetworksToMonitor").build())
            .build();

    private static final SdkField<InternetMeasurementsLogDelivery> INTERNET_MEASUREMENTS_LOG_DELIVERY_FIELD = SdkField
            .<InternetMeasurementsLogDelivery> builder(MarshallingType.SDK_POJO)
            .memberName("InternetMeasurementsLogDelivery")
            .getter(getter(GetMonitorResponse::internetMeasurementsLogDelivery))
            .setter(setter(Builder::internetMeasurementsLogDelivery))
            .constructor(InternetMeasurementsLogDelivery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetMeasurementsLogDelivery")
                    .build()).build();

    private static final SdkField<Integer> TRAFFIC_PERCENTAGE_TO_MONITOR_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TrafficPercentageToMonitor")
            .getter(getter(GetMonitorResponse::trafficPercentageToMonitor))
            .setter(setter(Builder::trafficPercentageToMonitor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPercentageToMonitor").build())
            .build();

    private static final SdkField<HealthEventsConfig> HEALTH_EVENTS_CONFIG_FIELD = SdkField
            .<HealthEventsConfig> builder(MarshallingType.SDK_POJO).memberName("HealthEventsConfig")
            .getter(getter(GetMonitorResponse::healthEventsConfig)).setter(setter(Builder::healthEventsConfig))
            .constructor(HealthEventsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventsConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD,
            MONITOR_ARN_FIELD, RESOURCES_FIELD, STATUS_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, PROCESSING_STATUS_FIELD,
            PROCESSING_STATUS_INFO_FIELD, TAGS_FIELD, MAX_CITY_NETWORKS_TO_MONITOR_FIELD,
            INTERNET_MEASUREMENTS_LOG_DELIVERY_FIELD, TRAFFIC_PERCENTAGE_TO_MONITOR_FIELD, HEALTH_EVENTS_CONFIG_FIELD));

    private final String monitorName;

    private final String monitorArn;

    private final List<String> resources;

    private final String status;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String processingStatus;

    private final String processingStatusInfo;

    private final Map<String, String> tags;

    private final Integer maxCityNetworksToMonitor;

    private final InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;

    private final Integer trafficPercentageToMonitor;

    private final HealthEventsConfig healthEventsConfig;

    private GetMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.monitorArn = builder.monitorArn;
        this.resources = builder.resources;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.processingStatus = builder.processingStatus;
        this.processingStatusInfo = builder.processingStatusInfo;
        this.tags = builder.tags;
        this.maxCityNetworksToMonitor = builder.maxCityNetworksToMonitor;
        this.internetMeasurementsLogDelivery = builder.internetMeasurementsLogDelivery;
        this.trafficPercentageToMonitor = builder.trafficPercentageToMonitor;
        this.healthEventsConfig = builder.healthEventsConfig;
    }

    /**
     * <p>
     * The name of the monitor.
     * </p>
     * 
     * @return The name of the monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitor.
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources that have been added for the monitor. Resources are listed by their Amazon Resource Names (ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return The resources that have been added for the monitor. Resources are listed by their Amazon Resource Names
     *         (ARNs).
     */
    public final List<String> resources() {
        return resources;
    }

    /**
     * <p>
     * The status of the monitor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MonitorConfigState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the monitor.
     * @see MonitorConfigState
     */
    public final MonitorConfigState status() {
        return MonitorConfigState.fromValue(status);
    }

    /**
     * <p>
     * The status of the monitor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MonitorConfigState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the monitor.
     * @see MonitorConfigState
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time when the monitor was created.
     * </p>
     * 
     * @return The time when the monitor was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The last time that the monitor was modified.
     * </p>
     * 
     * @return The last time that the monitor was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The health of the data processing for the monitor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processingStatus}
     * will return {@link MonitorProcessingStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #processingStatusAsString}.
     * </p>
     * 
     * @return The health of the data processing for the monitor.
     * @see MonitorProcessingStatusCode
     */
    public final MonitorProcessingStatusCode processingStatus() {
        return MonitorProcessingStatusCode.fromValue(processingStatus);
    }

    /**
     * <p>
     * The health of the data processing for the monitor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processingStatus}
     * will return {@link MonitorProcessingStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #processingStatusAsString}.
     * </p>
     * 
     * @return The health of the data processing for the monitor.
     * @see MonitorProcessingStatusCode
     */
    public final String processingStatusAsString() {
        return processingStatus;
    }

    /**
     * <p>
     * Additional information about the health of the data processing for the monitor.
     * </p>
     * 
     * @return Additional information about the health of the data processing for the monitor.
     */
    public final String processingStatusInfo() {
        return processingStatusInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that have been added to monitor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that have been added to monitor.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where
     * clients access your application resources from and the network or ASN, such as an internet service provider
     * (ISP), that clients access the resources through. This limit helps control billing costs.
     * </p>
     * <p>
     * To learn more, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing a
     * city-network maximum value </a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User
     * Guide</i>.
     * </p>
     * 
     * @return The maximum number of city-networks to monitor for your resources. A city-network is the location (city)
     *         where clients access your application resources from and the network or ASN, such as an internet service
     *         provider (ISP), that clients access the resources through. This limit helps control billing costs.</p>
     *         <p>
     *         To learn more, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing
     *         a city-network maximum value </a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch
     *         User Guide</i>.
     */
    public final Integer maxCityNetworksToMonitor() {
        return maxCityNetworksToMonitor;
    }

    /**
     * <p>
     * Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The
     * measurements are also published to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The
     *         measurements are also published to Amazon CloudWatch Logs.
     */
    public final InternetMeasurementsLogDelivery internetMeasurementsLogDelivery() {
        return internetMeasurementsLogDelivery;
    }

    /**
     * <p>
     * The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
     * </p>
     * 
     * @return The percentage of the internet-facing traffic for your application that you want to monitor with this
     *         monitor.
     */
    public final Integer trafficPercentageToMonitor() {
        return trafficPercentageToMonitor;
    }

    /**
     * <p>
     * The list of health event thresholds. A health event threshold percentage, for performance and availability,
     * determines the level of impact at which Amazon CloudWatch Internet Monitor creates a health event when there's an
     * internet issue that affects your application end users.
     * </p>
     * 
     * @return The list of health event thresholds. A health event threshold percentage, for performance and
     *         availability, determines the level of impact at which Amazon CloudWatch Internet Monitor creates a health
     *         event when there's an internet issue that affects your application end users.
     */
    public final HealthEventsConfig healthEventsConfig() {
        return healthEventsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(processingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(processingStatusInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxCityNetworksToMonitor());
        hashCode = 31 * hashCode + Objects.hashCode(internetMeasurementsLogDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPercentageToMonitor());
        hashCode = 31 * hashCode + Objects.hashCode(healthEventsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMonitorResponse)) {
            return false;
        }
        GetMonitorResponse other = (GetMonitorResponse) obj;
        return Objects.equals(monitorName(), other.monitorName()) && Objects.equals(monitorArn(), other.monitorArn())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(processingStatusAsString(), other.processingStatusAsString())
                && Objects.equals(processingStatusInfo(), other.processingStatusInfo()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(maxCityNetworksToMonitor(), other.maxCityNetworksToMonitor())
                && Objects.equals(internetMeasurementsLogDelivery(), other.internetMeasurementsLogDelivery())
                && Objects.equals(trafficPercentageToMonitor(), other.trafficPercentageToMonitor())
                && Objects.equals(healthEventsConfig(), other.healthEventsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMonitorResponse").add("MonitorName", monitorName()).add("MonitorArn", monitorArn())
                .add("Resources", hasResources() ? resources() : null).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("ProcessingStatus", processingStatusAsString()).add("ProcessingStatusInfo", processingStatusInfo())
                .add("Tags", hasTags() ? tags() : null).add("MaxCityNetworksToMonitor", maxCityNetworksToMonitor())
                .add("InternetMeasurementsLogDelivery", internetMeasurementsLogDelivery())
                .add("TrafficPercentageToMonitor", trafficPercentageToMonitor()).add("HealthEventsConfig", healthEventsConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "MonitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "ProcessingStatus":
            return Optional.ofNullable(clazz.cast(processingStatusAsString()));
        case "ProcessingStatusInfo":
            return Optional.ofNullable(clazz.cast(processingStatusInfo()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "MaxCityNetworksToMonitor":
            return Optional.ofNullable(clazz.cast(maxCityNetworksToMonitor()));
        case "InternetMeasurementsLogDelivery":
            return Optional.ofNullable(clazz.cast(internetMeasurementsLogDelivery()));
        case "TrafficPercentageToMonitor":
            return Optional.ofNullable(clazz.cast(trafficPercentageToMonitor()));
        case "HealthEventsConfig":
            return Optional.ofNullable(clazz.cast(healthEventsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMonitorResponse, T> g) {
        return obj -> g.apply((GetMonitorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InternetMonitorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMonitorResponse> {
        /**
         * <p>
         * The name of the monitor.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitor.
         * </p>
         * 
         * @param monitorArn
         *        The Amazon Resource Name (ARN) of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * The resources that have been added for the monitor. Resources are listed by their Amazon Resource Names
         * (ARNs).
         * </p>
         * 
         * @param resources
         *        The resources that have been added for the monitor. Resources are listed by their Amazon Resource
         *        Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * The resources that have been added for the monitor. Resources are listed by their Amazon Resource Names
         * (ARNs).
         * </p>
         * 
         * @param resources
         *        The resources that have been added for the monitor. Resources are listed by their Amazon Resource
         *        Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);

        /**
         * <p>
         * The status of the monitor.
         * </p>
         * 
         * @param status
         *        The status of the monitor.
         * @see MonitorConfigState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorConfigState
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the monitor.
         * </p>
         * 
         * @param status
         *        The status of the monitor.
         * @see MonitorConfigState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorConfigState
         */
        Builder status(MonitorConfigState status);

        /**
         * <p>
         * The time when the monitor was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the monitor was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The last time that the monitor was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The last time that the monitor was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The health of the data processing for the monitor.
         * </p>
         * 
         * @param processingStatus
         *        The health of the data processing for the monitor.
         * @see MonitorProcessingStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorProcessingStatusCode
         */
        Builder processingStatus(String processingStatus);

        /**
         * <p>
         * The health of the data processing for the monitor.
         * </p>
         * 
         * @param processingStatus
         *        The health of the data processing for the monitor.
         * @see MonitorProcessingStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorProcessingStatusCode
         */
        Builder processingStatus(MonitorProcessingStatusCode processingStatus);

        /**
         * <p>
         * Additional information about the health of the data processing for the monitor.
         * </p>
         * 
         * @param processingStatusInfo
         *        Additional information about the health of the data processing for the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingStatusInfo(String processingStatusInfo);

        /**
         * <p>
         * The tags that have been added to monitor.
         * </p>
         * 
         * @param tags
         *        The tags that have been added to monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The maximum number of city-networks to monitor for your resources. A city-network is the location (city)
         * where clients access your application resources from and the network or ASN, such as an internet service
         * provider (ISP), that clients access the resources through. This limit helps control billing costs.
         * </p>
         * <p>
         * To learn more, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing a
         * city-network maximum value </a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User
         * Guide</i>.
         * </p>
         * 
         * @param maxCityNetworksToMonitor
         *        The maximum number of city-networks to monitor for your resources. A city-network is the location
         *        (city) where clients access your application resources from and the network or ASN, such as an
         *        internet service provider (ISP), that clients access the resources through. This limit helps control
         *        billing costs.</p>
         *        <p>
         *        To learn more, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html"
         *        >Choosing a city-network maximum value </a> in the Amazon CloudWatch Internet Monitor section of the
         *        <i>CloudWatch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCityNetworksToMonitor(Integer maxCityNetworksToMonitor);

        /**
         * <p>
         * Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The
         * measurements are also published to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param internetMeasurementsLogDelivery
         *        Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket.
         *        The measurements are also published to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery internetMeasurementsLogDelivery);

        /**
         * <p>
         * Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The
         * measurements are also published to Amazon CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link InternetMeasurementsLogDelivery.Builder}
         * avoiding the need to create one manually via {@link InternetMeasurementsLogDelivery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InternetMeasurementsLogDelivery.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery)}.
         * 
         * @param internetMeasurementsLogDelivery
         *        a consumer that will call methods on {@link InternetMeasurementsLogDelivery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery)
         */
        default Builder internetMeasurementsLogDelivery(
                Consumer<InternetMeasurementsLogDelivery.Builder> internetMeasurementsLogDelivery) {
            return internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery.builder()
                    .applyMutation(internetMeasurementsLogDelivery).build());
        }

        /**
         * <p>
         * The percentage of the internet-facing traffic for your application that you want to monitor with this
         * monitor.
         * </p>
         * 
         * @param trafficPercentageToMonitor
         *        The percentage of the internet-facing traffic for your application that you want to monitor with this
         *        monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPercentageToMonitor(Integer trafficPercentageToMonitor);

        /**
         * <p>
         * The list of health event thresholds. A health event threshold percentage, for performance and availability,
         * determines the level of impact at which Amazon CloudWatch Internet Monitor creates a health event when
         * there's an internet issue that affects your application end users.
         * </p>
         * 
         * @param healthEventsConfig
         *        The list of health event thresholds. A health event threshold percentage, for performance and
         *        availability, determines the level of impact at which Amazon CloudWatch Internet Monitor creates a
         *        health event when there's an internet issue that affects your application end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthEventsConfig(HealthEventsConfig healthEventsConfig);

        /**
         * <p>
         * The list of health event thresholds. A health event threshold percentage, for performance and availability,
         * determines the level of impact at which Amazon CloudWatch Internet Monitor creates a health event when
         * there's an internet issue that affects your application end users.
         * </p>
         * This is a convenience method that creates an instance of the {@link HealthEventsConfig.Builder} avoiding the
         * need to create one manually via {@link HealthEventsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HealthEventsConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthEventsConfig(HealthEventsConfig)}.
         * 
         * @param healthEventsConfig
         *        a consumer that will call methods on {@link HealthEventsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthEventsConfig(HealthEventsConfig)
         */
        default Builder healthEventsConfig(Consumer<HealthEventsConfig.Builder> healthEventsConfig) {
            return healthEventsConfig(HealthEventsConfig.builder().applyMutation(healthEventsConfig).build());
        }
    }

    static final class BuilderImpl extends InternetMonitorResponse.BuilderImpl implements Builder {
        private String monitorName;

        private String monitorArn;

        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Instant createdAt;

        private Instant modifiedAt;

        private String processingStatus;

        private String processingStatusInfo;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxCityNetworksToMonitor;

        private InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;

        private Integer trafficPercentageToMonitor;

        private HealthEventsConfig healthEventsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMonitorResponse model) {
            super(model);
            monitorName(model.monitorName);
            monitorArn(model.monitorArn);
            resources(model.resources);
            status(model.status);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            processingStatus(model.processingStatus);
            processingStatusInfo(model.processingStatusInfo);
            tags(model.tags);
            maxCityNetworksToMonitor(model.maxCityNetworksToMonitor);
            internetMeasurementsLogDelivery(model.internetMeasurementsLogDelivery);
            trafficPercentageToMonitor(model.trafficPercentageToMonitor);
            healthEventsConfig(model.healthEventsConfig);
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final Collection<String> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = SetOfARNsCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = SetOfARNsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MonitorConfigState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getProcessingStatus() {
            return processingStatus;
        }

        public final void setProcessingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
        }

        @Override
        public final Builder processingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
            return this;
        }

        @Override
        public final Builder processingStatus(MonitorProcessingStatusCode processingStatus) {
            this.processingStatus(processingStatus == null ? null : processingStatus.toString());
            return this;
        }

        public final String getProcessingStatusInfo() {
            return processingStatusInfo;
        }

        public final void setProcessingStatusInfo(String processingStatusInfo) {
            this.processingStatusInfo = processingStatusInfo;
        }

        @Override
        public final Builder processingStatusInfo(String processingStatusInfo) {
            this.processingStatusInfo = processingStatusInfo;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Integer getMaxCityNetworksToMonitor() {
            return maxCityNetworksToMonitor;
        }

        public final void setMaxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
            this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
        }

        @Override
        public final Builder maxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
            this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
            return this;
        }

        public final InternetMeasurementsLogDelivery.Builder getInternetMeasurementsLogDelivery() {
            return internetMeasurementsLogDelivery != null ? internetMeasurementsLogDelivery.toBuilder() : null;
        }

        public final void setInternetMeasurementsLogDelivery(
                InternetMeasurementsLogDelivery.BuilderImpl internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery != null ? internetMeasurementsLogDelivery
                    .build() : null;
        }

        @Override
        public final Builder internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery;
            return this;
        }

        public final Integer getTrafficPercentageToMonitor() {
            return trafficPercentageToMonitor;
        }

        public final void setTrafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
            this.trafficPercentageToMonitor = trafficPercentageToMonitor;
        }

        @Override
        public final Builder trafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
            this.trafficPercentageToMonitor = trafficPercentageToMonitor;
            return this;
        }

        public final HealthEventsConfig.Builder getHealthEventsConfig() {
            return healthEventsConfig != null ? healthEventsConfig.toBuilder() : null;
        }

        public final void setHealthEventsConfig(HealthEventsConfig.BuilderImpl healthEventsConfig) {
            this.healthEventsConfig = healthEventsConfig != null ? healthEventsConfig.build() : null;
        }

        @Override
        public final Builder healthEventsConfig(HealthEventsConfig healthEventsConfig) {
            this.healthEventsConfig = healthEventsConfig;
            return this;
        }

        @Override
        public GetMonitorResponse build() {
            return new GetMonitorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
