/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HealthEventImpactType {
    AVAILABILITY("AVAILABILITY"),
    PERFORMANCE("PERFORMANCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HealthEventImpactType> VALUE_MAP;
    private final String value;

    private HealthEventImpactType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HealthEventImpactType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HealthEventImpactType> knownValues() {
        EnumSet<HealthEventImpactType> knownValues = EnumSet.allOf(HealthEventImpactType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HealthEventImpactType.class, HealthEventImpactType::toString);
    }
}

