/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.internetmonitor.DefaultInternetMonitorClientBuilder;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorClientBuilder;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorServiceClientConfiguration;
import software.amazon.awssdk.services.internetmonitor.model.AccessDeniedException;
import software.amazon.awssdk.services.internetmonitor.model.BadRequestException;
import software.amazon.awssdk.services.internetmonitor.model.ConflictException;
import software.amazon.awssdk.services.internetmonitor.model.CreateMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.CreateMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.GetHealthEventRequest;
import software.amazon.awssdk.services.internetmonitor.model.GetHealthEventResponse;
import software.amazon.awssdk.services.internetmonitor.model.GetMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.GetMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.InternalServerErrorException;
import software.amazon.awssdk.services.internetmonitor.model.InternalServerException;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorException;
import software.amazon.awssdk.services.internetmonitor.model.LimitExceededException;
import software.amazon.awssdk.services.internetmonitor.model.ListHealthEventsRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListHealthEventsResponse;
import software.amazon.awssdk.services.internetmonitor.model.ListMonitorsRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListMonitorsResponse;
import software.amazon.awssdk.services.internetmonitor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.internetmonitor.model.NotFoundException;
import software.amazon.awssdk.services.internetmonitor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.internetmonitor.model.TagResourceRequest;
import software.amazon.awssdk.services.internetmonitor.model.TagResourceResponse;
import software.amazon.awssdk.services.internetmonitor.model.ThrottlingException;
import software.amazon.awssdk.services.internetmonitor.model.TooManyRequestsException;
import software.amazon.awssdk.services.internetmonitor.model.UntagResourceRequest;
import software.amazon.awssdk.services.internetmonitor.model.UntagResourceResponse;
import software.amazon.awssdk.services.internetmonitor.model.UpdateMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.UpdateMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.ValidationException;
import software.amazon.awssdk.services.internetmonitor.paginators.ListHealthEventsIterable;
import software.amazon.awssdk.services.internetmonitor.paginators.ListMonitorsIterable;

@SdkPublicApi
@ThreadSafe
public interface InternetMonitorClient
extends AwsClient {
    public static final String SERVICE_NAME = "internetmonitor";
    public static final String SERVICE_METADATA_ID = "internetmonitor";

    default public CreateMonitorResponse createMonitor(CreateMonitorRequest createMonitorRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ConflictException, LimitExceededException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public CreateMonitorResponse createMonitor(Consumer<CreateMonitorRequest.Builder> createMonitorRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ConflictException, LimitExceededException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.createMonitor((CreateMonitorRequest)((Object)((CreateMonitorRequest.Builder)CreateMonitorRequest.builder().applyMutation(createMonitorRequest)).build()));
    }

    default public DeleteMonitorResponse deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public DeleteMonitorResponse deleteMonitor(Consumer<DeleteMonitorRequest.Builder> deleteMonitorRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.deleteMonitor((DeleteMonitorRequest)((Object)((DeleteMonitorRequest.Builder)DeleteMonitorRequest.builder().applyMutation(deleteMonitorRequest)).build()));
    }

    default public GetHealthEventResponse getHealthEvent(GetHealthEventRequest getHealthEventRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public GetHealthEventResponse getHealthEvent(Consumer<GetHealthEventRequest.Builder> getHealthEventRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.getHealthEvent((GetHealthEventRequest)((Object)((GetHealthEventRequest.Builder)GetHealthEventRequest.builder().applyMutation(getHealthEventRequest)).build()));
    }

    default public GetMonitorResponse getMonitor(GetMonitorRequest getMonitorRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public GetMonitorResponse getMonitor(Consumer<GetMonitorRequest.Builder> getMonitorRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.getMonitor((GetMonitorRequest)((Object)((GetMonitorRequest.Builder)GetMonitorRequest.builder().applyMutation(getMonitorRequest)).build()));
    }

    default public ListHealthEventsResponse listHealthEvents(ListHealthEventsRequest listHealthEventsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public ListHealthEventsResponse listHealthEvents(Consumer<ListHealthEventsRequest.Builder> listHealthEventsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.listHealthEvents((ListHealthEventsRequest)((Object)((ListHealthEventsRequest.Builder)ListHealthEventsRequest.builder().applyMutation(listHealthEventsRequest)).build()));
    }

    default public ListHealthEventsIterable listHealthEventsPaginator(ListHealthEventsRequest listHealthEventsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public ListHealthEventsIterable listHealthEventsPaginator(Consumer<ListHealthEventsRequest.Builder> listHealthEventsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.listHealthEventsPaginator((ListHealthEventsRequest)((Object)((ListHealthEventsRequest.Builder)ListHealthEventsRequest.builder().applyMutation(listHealthEventsRequest)).build()));
    }

    default public ListMonitorsResponse listMonitors(ListMonitorsRequest listMonitorsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public ListMonitorsResponse listMonitors(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.listMonitors((ListMonitorsRequest)((Object)((ListMonitorsRequest.Builder)ListMonitorsRequest.builder().applyMutation(listMonitorsRequest)).build()));
    }

    default public ListMonitorsIterable listMonitorsPaginator(ListMonitorsRequest listMonitorsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public ListMonitorsIterable listMonitorsPaginator(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.listMonitorsPaginator((ListMonitorsRequest)((Object)((ListMonitorsRequest.Builder)ListMonitorsRequest.builder().applyMutation(listMonitorsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws TooManyRequestsException, AccessDeniedException, NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws TooManyRequestsException, AccessDeniedException, NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyRequestsException, AccessDeniedException, NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws TooManyRequestsException, AccessDeniedException, NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws TooManyRequestsException, AccessDeniedException, NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws TooManyRequestsException, AccessDeniedException, NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateMonitorResponse updateMonitor(UpdateMonitorRequest updateMonitorRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, LimitExceededException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        throw new UnsupportedOperationException();
    }

    default public UpdateMonitorResponse updateMonitor(Consumer<UpdateMonitorRequest.Builder> updateMonitorRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, LimitExceededException, ValidationException, AwsServiceException, SdkClientException, InternetMonitorException {
        return this.updateMonitor((UpdateMonitorRequest)((Object)((UpdateMonitorRequest.Builder)UpdateMonitorRequest.builder().applyMutation(updateMonitorRequest)).build()));
    }

    public static InternetMonitorClient create() {
        return (InternetMonitorClient)InternetMonitorClient.builder().build();
    }

    public static InternetMonitorClientBuilder builder() {
        return new DefaultInternetMonitorClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"internetmonitor");
    }

    default public InternetMonitorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

