/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HealthEventStatus {
    ACTIVE("ACTIVE"),
    RESOLVED("RESOLVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HealthEventStatus> VALUE_MAP;
    private final String value;

    private HealthEventStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HealthEventStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HealthEventStatus> knownValues() {
        EnumSet<HealthEventStatus> knownValues = EnumSet.allOf(HealthEventStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HealthEventStatus.class, HealthEventStatus::toString);
    }
}

