/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReportStatus {
    WORK_IN_PROGRESS("WORK_IN_PROGRESS"),
    FAILED("FAILED"),
    COMPLETED("COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReportStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReportStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportStatus> knownValues() {
        return Stream.of(ReportStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

