/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.services.inspector.model.ListReturnedArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExclusionsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, ListExclusionsResponse> {
    private static final SdkField<List<String>> EXCLUSION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exclusionArns").getter(ListExclusionsResponse.getter(ListExclusionsResponse::exclusionArns)).setter(ListExclusionsResponse.setter(Builder::exclusionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExclusionsResponse.getter(ListExclusionsResponse::nextToken)).setter(ListExclusionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSION_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> exclusionArns;
    private final String nextToken;

    private ListExclusionsResponse(BuilderImpl builder) {
        super(builder);
        this.exclusionArns = builder.exclusionArns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExclusionArns() {
        return this.exclusionArns != null && !(this.exclusionArns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionArns() {
        return this.exclusionArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionArns() ? this.exclusionArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExclusionsResponse)) {
            return false;
        }
        ListExclusionsResponse other = (ListExclusionsResponse)((Object)obj);
        return this.hasExclusionArns() == other.hasExclusionArns() && Objects.equals(this.exclusionArns(), other.exclusionArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExclusionsResponse").add("ExclusionArns", this.hasExclusionArns() ? this.exclusionArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exclusionArns": {
                return Optional.ofNullable(clazz.cast(this.exclusionArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExclusionsResponse, T> g) {
        return obj -> g.apply((ListExclusionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<String> exclusionArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExclusionsResponse model) {
            super(model);
            this.exclusionArns(model.exclusionArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getExclusionArns() {
            if (this.exclusionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionArns;
        }

        @Override
        public final Builder exclusionArns(Collection<String> exclusionArns) {
            this.exclusionArns = ListReturnedArnListCopier.copy(exclusionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionArns(String ... exclusionArns) {
            this.exclusionArns(Arrays.asList(exclusionArns));
            return this;
        }

        public final void setExclusionArns(Collection<String> exclusionArns) {
            this.exclusionArns = ListReturnedArnListCopier.copy(exclusionArns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListExclusionsResponse build() {
            return new ListExclusionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExclusionsResponse> {
        public Builder exclusionArns(Collection<String> var1);

        public Builder exclusionArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

