/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FailedItemErrorCode {
    INVALID_ARN("INVALID_ARN"),
    DUPLICATE_ARN("DUPLICATE_ARN"),
    ITEM_DOES_NOT_EXIST("ITEM_DOES_NOT_EXIST"),
    ACCESS_DENIED("ACCESS_DENIED"),
    LIMIT_EXCEEDED("LIMIT_EXCEEDED"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FailedItemErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailedItemErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FailedItemErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailedItemErrorCode> knownValues() {
        return Stream.of(FailedItemErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

