/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCrossAccountAccessRoleResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, DescribeCrossAccountAccessRoleResponse> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeCrossAccountAccessRoleResponse.getter(DescribeCrossAccountAccessRoleResponse::roleArn)).setter(DescribeCrossAccountAccessRoleResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Boolean> VALID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("valid").getter(DescribeCrossAccountAccessRoleResponse.getter(DescribeCrossAccountAccessRoleResponse::valid)).setter(DescribeCrossAccountAccessRoleResponse.setter(Builder::valid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valid").build()}).build();
    private static final SdkField<Instant> REGISTERED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("registeredAt").getter(DescribeCrossAccountAccessRoleResponse.getter(DescribeCrossAccountAccessRoleResponse::registeredAt)).setter(DescribeCrossAccountAccessRoleResponse.setter(Builder::registeredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, VALID_FIELD, REGISTERED_AT_FIELD));
    private final String roleArn;
    private final Boolean valid;
    private final Instant registeredAt;

    private DescribeCrossAccountAccessRoleResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.valid = builder.valid;
        this.registeredAt = builder.registeredAt;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Boolean valid() {
        return this.valid;
    }

    public final Instant registeredAt() {
        return this.registeredAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.valid());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCrossAccountAccessRoleResponse)) {
            return false;
        }
        DescribeCrossAccountAccessRoleResponse other = (DescribeCrossAccountAccessRoleResponse)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.valid(), other.valid()) && Objects.equals(this.registeredAt(), other.registeredAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCrossAccountAccessRoleResponse").add("RoleArn", (Object)this.roleArn()).add("Valid", (Object)this.valid()).add("RegisteredAt", (Object)this.registeredAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "valid": {
                return Optional.ofNullable(clazz.cast(this.valid()));
            }
            case "registeredAt": {
                return Optional.ofNullable(clazz.cast(this.registeredAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCrossAccountAccessRoleResponse, T> g) {
        return obj -> g.apply((DescribeCrossAccountAccessRoleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private String roleArn;
        private Boolean valid;
        private Instant registeredAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCrossAccountAccessRoleResponse model) {
            super(model);
            this.roleArn(model.roleArn);
            this.valid(model.valid);
            this.registeredAt(model.registeredAt);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Boolean getValid() {
            return this.valid;
        }

        @Override
        public final Builder valid(Boolean valid) {
            this.valid = valid;
            return this;
        }

        public final void setValid(Boolean valid) {
            this.valid = valid;
        }

        public final Instant getRegisteredAt() {
            return this.registeredAt;
        }

        @Override
        public final Builder registeredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        public final void setRegisteredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
        }

        @Override
        public DescribeCrossAccountAccessRoleResponse build() {
            return new DescribeCrossAccountAccessRoleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCrossAccountAccessRoleResponse> {
        public Builder roleArn(String var1);

        public Builder valid(Boolean var1);

        public Builder registeredAt(Instant var1);
    }
}

