/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.Ipv4AddressListCopier;
import software.amazon.awssdk.services.inspector.model.NetworkInterface;
import software.amazon.awssdk.services.inspector.model.NetworkInterfacesCopier;
import software.amazon.awssdk.services.inspector.model.Tag;
import software.amazon.awssdk.services.inspector.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetAttributes> {
    private static final SdkField<Integer> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("schemaVersion").getter(AssetAttributes.getter(AssetAttributes::schemaVersion)).setter(AssetAttributes.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(AssetAttributes.getter(AssetAttributes::agentId)).setter(AssetAttributes.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingGroup").getter(AssetAttributes.getter(AssetAttributes::autoScalingGroup)).setter(AssetAttributes.setter(Builder::autoScalingGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroup").build()}).build();
    private static final SdkField<String> AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("amiId").getter(AssetAttributes.getter(AssetAttributes::amiId)).setter(AssetAttributes.setter(Builder::amiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiId").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(AssetAttributes.getter(AssetAttributes::hostname)).setter(AssetAttributes.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<List<String>> IPV4_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipv4Addresses").getter(AssetAttributes.getter(AssetAttributes::ipv4Addresses)).setter(AssetAttributes.setter(Builder::ipv4Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv4Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(AssetAttributes.getter(AssetAttributes::tags)).setter(AssetAttributes.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInterfaces").getter(AssetAttributes.getter(AssetAttributes::networkInterfaces)).setter(AssetAttributes.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD, AGENT_ID_FIELD, AUTO_SCALING_GROUP_FIELD, AMI_ID_FIELD, HOSTNAME_FIELD, IPV4_ADDRESSES_FIELD, TAGS_FIELD, NETWORK_INTERFACES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer schemaVersion;
    private final String agentId;
    private final String autoScalingGroup;
    private final String amiId;
    private final String hostname;
    private final List<String> ipv4Addresses;
    private final List<Tag> tags;
    private final List<NetworkInterface> networkInterfaces;

    private AssetAttributes(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.agentId = builder.agentId;
        this.autoScalingGroup = builder.autoScalingGroup;
        this.amiId = builder.amiId;
        this.hostname = builder.hostname;
        this.ipv4Addresses = builder.ipv4Addresses;
        this.tags = builder.tags;
        this.networkInterfaces = builder.networkInterfaces;
    }

    public final Integer schemaVersion() {
        return this.schemaVersion;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String autoScalingGroup() {
        return this.autoScalingGroup;
    }

    public final String amiId() {
        return this.amiId;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final boolean hasIpv4Addresses() {
        return this.ipv4Addresses != null && !(this.ipv4Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipv4Addresses() {
        return this.ipv4Addresses;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Addresses() ? this.ipv4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetAttributes)) {
            return false;
        }
        AssetAttributes other = (AssetAttributes)obj;
        return Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.autoScalingGroup(), other.autoScalingGroup()) && Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.hostname(), other.hostname()) && this.hasIpv4Addresses() == other.hasIpv4Addresses() && Objects.equals(this.ipv4Addresses(), other.ipv4Addresses()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces());
    }

    public final String toString() {
        return ToString.builder((String)"AssetAttributes").add("SchemaVersion", (Object)this.schemaVersion()).add("AgentId", (Object)this.agentId()).add("AutoScalingGroup", (Object)this.autoScalingGroup()).add("AmiId", (Object)this.amiId()).add("Hostname", (Object)this.hostname()).add("Ipv4Addresses", this.hasIpv4Addresses() ? this.ipv4Addresses() : null).add("Tags", this.hasTags() ? this.tags() : null).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "autoScalingGroup": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroup()));
            }
            case "amiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "ipv4Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv4Addresses()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "networkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetAttributes, T> g) {
        return obj -> g.apply((AssetAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer schemaVersion;
        private String agentId;
        private String autoScalingGroup;
        private String amiId;
        private String hostname;
        private List<String> ipv4Addresses = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetAttributes model) {
            this.schemaVersion(model.schemaVersion);
            this.agentId(model.agentId);
            this.autoScalingGroup(model.autoScalingGroup);
            this.amiId(model.amiId);
            this.hostname(model.hostname);
            this.ipv4Addresses(model.ipv4Addresses);
            this.tags(model.tags);
            this.networkInterfaces(model.networkInterfaces);
        }

        public final Integer getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public final String getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        @Override
        public final Builder autoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        public final void setAutoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final Collection<String> getIpv4Addresses() {
            if (this.ipv4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv4Addresses;
        }

        @Override
        public final Builder ipv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = Ipv4AddressListCopier.copy(ipv4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Addresses(String ... ipv4Addresses) {
            this.ipv4Addresses(Arrays.asList(ipv4Addresses));
            return this;
        }

        public final void setIpv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = Ipv4AddressListCopier.copy(ipv4Addresses);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<NetworkInterface.Builder> getNetworkInterfaces() {
            if (this.networkInterfaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(NetworkInterface::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        public AssetAttributes build() {
            return new AssetAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetAttributes> {
        public Builder schemaVersion(Integer var1);

        public Builder agentId(String var1);

        public Builder autoScalingGroup(String var1);

        public Builder amiId(String var1);

        public Builder hostname(String var1);

        public Builder ipv4Addresses(Collection<String> var1);

        public Builder ipv4Addresses(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... var1);
    }
}

