/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.DurationRange;
import software.amazon.awssdk.services.inspector.model.FilterRulesPackageArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentTemplateFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentTemplateFilter> {
    private static final SdkField<String> NAME_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namePattern").getter(AssessmentTemplateFilter.getter(AssessmentTemplateFilter::namePattern)).setter(AssessmentTemplateFilter.setter(Builder::namePattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namePattern").build()}).build();
    private static final SdkField<DurationRange> DURATION_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("durationRange").getter(AssessmentTemplateFilter.getter(AssessmentTemplateFilter::durationRange)).setter(AssessmentTemplateFilter.setter(Builder::durationRange)).constructor(DurationRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationRange").build()}).build();
    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rulesPackageArns").getter(AssessmentTemplateFilter.getter(AssessmentTemplateFilter::rulesPackageArns)).setter(AssessmentTemplateFilter.setter(Builder::rulesPackageArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PATTERN_FIELD, DURATION_RANGE_FIELD, RULES_PACKAGE_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String namePattern;
    private final DurationRange durationRange;
    private final List<String> rulesPackageArns;

    private AssessmentTemplateFilter(BuilderImpl builder) {
        this.namePattern = builder.namePattern;
        this.durationRange = builder.durationRange;
        this.rulesPackageArns = builder.rulesPackageArns;
    }

    public final String namePattern() {
        return this.namePattern;
    }

    public final DurationRange durationRange() {
        return this.durationRange;
    }

    public final boolean hasRulesPackageArns() {
        return this.rulesPackageArns != null && !(this.rulesPackageArns instanceof SdkAutoConstructList);
    }

    public final List<String> rulesPackageArns() {
        return this.rulesPackageArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namePattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesPackageArns() ? this.rulesPackageArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentTemplateFilter)) {
            return false;
        }
        AssessmentTemplateFilter other = (AssessmentTemplateFilter)obj;
        return Objects.equals(this.namePattern(), other.namePattern()) && Objects.equals(this.durationRange(), other.durationRange()) && this.hasRulesPackageArns() == other.hasRulesPackageArns() && Objects.equals(this.rulesPackageArns(), other.rulesPackageArns());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentTemplateFilter").add("NamePattern", (Object)this.namePattern()).add("DurationRange", (Object)this.durationRange()).add("RulesPackageArns", this.hasRulesPackageArns() ? this.rulesPackageArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namePattern": {
                return Optional.ofNullable(clazz.cast(this.namePattern()));
            }
            case "durationRange": {
                return Optional.ofNullable(clazz.cast(this.durationRange()));
            }
            case "rulesPackageArns": {
                return Optional.ofNullable(clazz.cast(this.rulesPackageArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentTemplateFilter, T> g) {
        return obj -> g.apply((AssessmentTemplateFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namePattern;
        private DurationRange durationRange;
        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentTemplateFilter model) {
            this.namePattern(model.namePattern);
            this.durationRange(model.durationRange);
            this.rulesPackageArns(model.rulesPackageArns);
        }

        public final String getNamePattern() {
            return this.namePattern;
        }

        @Override
        public final Builder namePattern(String namePattern) {
            this.namePattern = namePattern;
            return this;
        }

        public final void setNamePattern(String namePattern) {
            this.namePattern = namePattern;
        }

        public final DurationRange.Builder getDurationRange() {
            return this.durationRange != null ? this.durationRange.toBuilder() : null;
        }

        @Override
        public final Builder durationRange(DurationRange durationRange) {
            this.durationRange = durationRange;
            return this;
        }

        public final void setDurationRange(DurationRange.BuilderImpl durationRange) {
            this.durationRange = durationRange != null ? durationRange.build() : null;
        }

        public final Collection<String> getRulesPackageArns() {
            if (this.rulesPackageArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String ... rulesPackageArns) {
            this.rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        public AssessmentTemplateFilter build() {
            return new AssessmentTemplateFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentTemplateFilter> {
        public Builder namePattern(String var1);

        public Builder durationRange(DurationRange var1);

        default public Builder durationRange(Consumer<DurationRange.Builder> durationRange) {
            return this.durationRange((DurationRange)((DurationRange.Builder)DurationRange.builder().applyMutation(durationRange)).build());
        }

        public Builder rulesPackageArns(Collection<String> var1);

        public Builder rulesPackageArns(String ... var1);
    }
}

