/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AssessmentRunState;
import software.amazon.awssdk.services.inspector.model.AssessmentRunStateListCopier;
import software.amazon.awssdk.services.inspector.model.DurationRange;
import software.amazon.awssdk.services.inspector.model.FilterRulesPackageArnListCopier;
import software.amazon.awssdk.services.inspector.model.TimestampRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentRunFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentRunFilter> {
    private static final SdkField<String> NAME_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namePattern").getter(AssessmentRunFilter.getter(AssessmentRunFilter::namePattern)).setter(AssessmentRunFilter.setter(Builder::namePattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namePattern").build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("states").getter(AssessmentRunFilter.getter(AssessmentRunFilter::statesAsStrings)).setter(AssessmentRunFilter.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("states").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DurationRange> DURATION_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("durationRange").getter(AssessmentRunFilter.getter(AssessmentRunFilter::durationRange)).setter(AssessmentRunFilter.setter(Builder::durationRange)).constructor(DurationRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationRange").build()}).build();
    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rulesPackageArns").getter(AssessmentRunFilter.getter(AssessmentRunFilter::rulesPackageArns)).setter(AssessmentRunFilter.setter(Builder::rulesPackageArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimestampRange> START_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("startTimeRange").getter(AssessmentRunFilter.getter(AssessmentRunFilter::startTimeRange)).setter(AssessmentRunFilter.setter(Builder::startTimeRange)).constructor(TimestampRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeRange").build()}).build();
    private static final SdkField<TimestampRange> COMPLETION_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("completionTimeRange").getter(AssessmentRunFilter.getter(AssessmentRunFilter::completionTimeRange)).setter(AssessmentRunFilter.setter(Builder::completionTimeRange)).constructor(TimestampRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTimeRange").build()}).build();
    private static final SdkField<TimestampRange> STATE_CHANGE_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stateChangeTimeRange").getter(AssessmentRunFilter.getter(AssessmentRunFilter::stateChangeTimeRange)).setter(AssessmentRunFilter.setter(Builder::stateChangeTimeRange)).constructor(TimestampRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangeTimeRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PATTERN_FIELD, STATES_FIELD, DURATION_RANGE_FIELD, RULES_PACKAGE_ARNS_FIELD, START_TIME_RANGE_FIELD, COMPLETION_TIME_RANGE_FIELD, STATE_CHANGE_TIME_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String namePattern;
    private final List<String> states;
    private final DurationRange durationRange;
    private final List<String> rulesPackageArns;
    private final TimestampRange startTimeRange;
    private final TimestampRange completionTimeRange;
    private final TimestampRange stateChangeTimeRange;

    private AssessmentRunFilter(BuilderImpl builder) {
        this.namePattern = builder.namePattern;
        this.states = builder.states;
        this.durationRange = builder.durationRange;
        this.rulesPackageArns = builder.rulesPackageArns;
        this.startTimeRange = builder.startTimeRange;
        this.completionTimeRange = builder.completionTimeRange;
        this.stateChangeTimeRange = builder.stateChangeTimeRange;
    }

    public final String namePattern() {
        return this.namePattern;
    }

    public final List<AssessmentRunState> states() {
        return AssessmentRunStateListCopier.copyStringToEnum(this.states);
    }

    public final boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public final List<String> statesAsStrings() {
        return this.states;
    }

    public final DurationRange durationRange() {
        return this.durationRange;
    }

    public final boolean hasRulesPackageArns() {
        return this.rulesPackageArns != null && !(this.rulesPackageArns instanceof SdkAutoConstructList);
    }

    public final List<String> rulesPackageArns() {
        return this.rulesPackageArns;
    }

    public final TimestampRange startTimeRange() {
        return this.startTimeRange;
    }

    public final TimestampRange completionTimeRange() {
        return this.completionTimeRange;
    }

    public final TimestampRange stateChangeTimeRange() {
        return this.stateChangeTimeRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namePattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStates() ? this.statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.durationRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesPackageArns() ? this.rulesPackageArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeTimeRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRunFilter)) {
            return false;
        }
        AssessmentRunFilter other = (AssessmentRunFilter)obj;
        return Objects.equals(this.namePattern(), other.namePattern()) && this.hasStates() == other.hasStates() && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && Objects.equals(this.durationRange(), other.durationRange()) && this.hasRulesPackageArns() == other.hasRulesPackageArns() && Objects.equals(this.rulesPackageArns(), other.rulesPackageArns()) && Objects.equals(this.startTimeRange(), other.startTimeRange()) && Objects.equals(this.completionTimeRange(), other.completionTimeRange()) && Objects.equals(this.stateChangeTimeRange(), other.stateChangeTimeRange());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentRunFilter").add("NamePattern", (Object)this.namePattern()).add("States", this.hasStates() ? this.statesAsStrings() : null).add("DurationRange", (Object)this.durationRange()).add("RulesPackageArns", this.hasRulesPackageArns() ? this.rulesPackageArns() : null).add("StartTimeRange", (Object)this.startTimeRange()).add("CompletionTimeRange", (Object)this.completionTimeRange()).add("StateChangeTimeRange", (Object)this.stateChangeTimeRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namePattern": {
                return Optional.ofNullable(clazz.cast(this.namePattern()));
            }
            case "states": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "durationRange": {
                return Optional.ofNullable(clazz.cast(this.durationRange()));
            }
            case "rulesPackageArns": {
                return Optional.ofNullable(clazz.cast(this.rulesPackageArns()));
            }
            case "startTimeRange": {
                return Optional.ofNullable(clazz.cast(this.startTimeRange()));
            }
            case "completionTimeRange": {
                return Optional.ofNullable(clazz.cast(this.completionTimeRange()));
            }
            case "stateChangeTimeRange": {
                return Optional.ofNullable(clazz.cast(this.stateChangeTimeRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunFilter, T> g) {
        return obj -> g.apply((AssessmentRunFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namePattern;
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private DurationRange durationRange;
        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();
        private TimestampRange startTimeRange;
        private TimestampRange completionTimeRange;
        private TimestampRange stateChangeTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunFilter model) {
            this.namePattern(model.namePattern);
            this.statesWithStrings(model.states);
            this.durationRange(model.durationRange);
            this.rulesPackageArns(model.rulesPackageArns);
            this.startTimeRange(model.startTimeRange);
            this.completionTimeRange(model.completionTimeRange);
            this.stateChangeTimeRange(model.stateChangeTimeRange);
        }

        public final String getNamePattern() {
            return this.namePattern;
        }

        @Override
        public final Builder namePattern(String namePattern) {
            this.namePattern = namePattern;
            return this;
        }

        public final void setNamePattern(String namePattern) {
            this.namePattern = namePattern;
        }

        public final Collection<String> getStates() {
            if (this.states instanceof SdkAutoConstructList) {
                return null;
            }
            return this.states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = AssessmentRunStateListCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<AssessmentRunState> states) {
            this.states = AssessmentRunStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(AssessmentRunState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = AssessmentRunStateListCopier.copy(states);
        }

        public final DurationRange.Builder getDurationRange() {
            return this.durationRange != null ? this.durationRange.toBuilder() : null;
        }

        @Override
        public final Builder durationRange(DurationRange durationRange) {
            this.durationRange = durationRange;
            return this;
        }

        public final void setDurationRange(DurationRange.BuilderImpl durationRange) {
            this.durationRange = durationRange != null ? durationRange.build() : null;
        }

        public final Collection<String> getRulesPackageArns() {
            if (this.rulesPackageArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String ... rulesPackageArns) {
            this.rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        public final TimestampRange.Builder getStartTimeRange() {
            return this.startTimeRange != null ? this.startTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder startTimeRange(TimestampRange startTimeRange) {
            this.startTimeRange = startTimeRange;
            return this;
        }

        public final void setStartTimeRange(TimestampRange.BuilderImpl startTimeRange) {
            this.startTimeRange = startTimeRange != null ? startTimeRange.build() : null;
        }

        public final TimestampRange.Builder getCompletionTimeRange() {
            return this.completionTimeRange != null ? this.completionTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder completionTimeRange(TimestampRange completionTimeRange) {
            this.completionTimeRange = completionTimeRange;
            return this;
        }

        public final void setCompletionTimeRange(TimestampRange.BuilderImpl completionTimeRange) {
            this.completionTimeRange = completionTimeRange != null ? completionTimeRange.build() : null;
        }

        public final TimestampRange.Builder getStateChangeTimeRange() {
            return this.stateChangeTimeRange != null ? this.stateChangeTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeTimeRange(TimestampRange stateChangeTimeRange) {
            this.stateChangeTimeRange = stateChangeTimeRange;
            return this;
        }

        public final void setStateChangeTimeRange(TimestampRange.BuilderImpl stateChangeTimeRange) {
            this.stateChangeTimeRange = stateChangeTimeRange != null ? stateChangeTimeRange.build() : null;
        }

        public AssessmentRunFilter build() {
            return new AssessmentRunFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentRunFilter> {
        public Builder namePattern(String var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<AssessmentRunState> var1);

        public Builder states(AssessmentRunState ... var1);

        public Builder durationRange(DurationRange var1);

        default public Builder durationRange(Consumer<DurationRange.Builder> durationRange) {
            return this.durationRange((DurationRange)((DurationRange.Builder)DurationRange.builder().applyMutation(durationRange)).build());
        }

        public Builder rulesPackageArns(Collection<String> var1);

        public Builder rulesPackageArns(String ... var1);

        public Builder startTimeRange(TimestampRange var1);

        default public Builder startTimeRange(Consumer<TimestampRange.Builder> startTimeRange) {
            return this.startTimeRange((TimestampRange)((TimestampRange.Builder)TimestampRange.builder().applyMutation(startTimeRange)).build());
        }

        public Builder completionTimeRange(TimestampRange var1);

        default public Builder completionTimeRange(Consumer<TimestampRange.Builder> completionTimeRange) {
            return this.completionTimeRange((TimestampRange)((TimestampRange.Builder)TimestampRange.builder().applyMutation(completionTimeRange)).build());
        }

        public Builder stateChangeTimeRange(TimestampRange var1);

        default public Builder stateChangeTimeRange(Consumer<TimestampRange.Builder> stateChangeTimeRange) {
            return this.stateChangeTimeRange((TimestampRange)((TimestampRange.Builder)TimestampRange.builder().applyMutation(stateChangeTimeRange)).build());
        }
    }
}

