/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AgentHealth {
    HEALTHY("HEALTHY"),
    UNHEALTHY("UNHEALTHY"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AgentHealth(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgentHealth fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AgentHealth.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AgentHealth> knownValues() {
        return Stream.of(AgentHealth.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

