/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssessmentTargetsResponse extends InspectorResponse implements
        ToCopyableBuilder<ListAssessmentTargetsResponse.Builder, ListAssessmentTargetsResponse> {
    private static final SdkField<List<String>> ASSESSMENT_TARGET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("assessmentTargetArns")
            .getter(getter(ListAssessmentTargetsResponse::assessmentTargetArns))
            .setter(setter(Builder::assessmentTargetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssessmentTargetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_ARNS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> assessmentTargetArns;

    private final String nextToken;

    private ListAssessmentTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetArns = builder.assessmentTargetArns;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AssessmentTargetArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAssessmentTargetArns() {
        return assessmentTargetArns != null && !(assessmentTargetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs that specifies the assessment targets that are returned by the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssessmentTargetArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of ARNs that specifies the assessment targets that are returned by the action.
     */
    public final List<String> assessmentTargetArns() {
        return assessmentTargetArns;
    }

    /**
     * <p>
     * When a response is generated, if there is more data to be listed, this parameter is present in the response and
     * contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no
     * more data to be listed, this parameter is set to null.
     * </p>
     * 
     * @return When a response is generated, if there is more data to be listed, this parameter is present in the
     *         response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination
     *         request. If there is no more data to be listed, this parameter is set to null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentTargetArns() ? assessmentTargetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentTargetsResponse)) {
            return false;
        }
        ListAssessmentTargetsResponse other = (ListAssessmentTargetsResponse) obj;
        return hasAssessmentTargetArns() == other.hasAssessmentTargetArns()
                && Objects.equals(assessmentTargetArns(), other.assessmentTargetArns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssessmentTargetsResponse")
                .add("AssessmentTargetArns", hasAssessmentTargetArns() ? assessmentTargetArns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTargetArns":
            return Optional.ofNullable(clazz.cast(assessmentTargetArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentTargetsResponse, T> g) {
        return obj -> g.apply((ListAssessmentTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAssessmentTargetsResponse> {
        /**
         * <p>
         * A list of ARNs that specifies the assessment targets that are returned by the action.
         * </p>
         * 
         * @param assessmentTargetArns
         *        A list of ARNs that specifies the assessment targets that are returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargetArns(Collection<String> assessmentTargetArns);

        /**
         * <p>
         * A list of ARNs that specifies the assessment targets that are returned by the action.
         * </p>
         * 
         * @param assessmentTargetArns
         *        A list of ARNs that specifies the assessment targets that are returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargetArns(String... assessmentTargetArns);

        /**
         * <p>
         * When a response is generated, if there is more data to be listed, this parameter is present in the response
         * and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there
         * is no more data to be listed, this parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        When a response is generated, if there is more data to be listed, this parameter is present in the
         *        response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination
         *        request. If there is no more data to be listed, this parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<String> assessmentTargetArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentTargetsResponse model) {
            super(model);
            assessmentTargetArns(model.assessmentTargetArns);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAssessmentTargetArns() {
            if (assessmentTargetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return assessmentTargetArns;
        }

        @Override
        public final Builder assessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = ListReturnedArnListCopier.copy(assessmentTargetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargetArns(String... assessmentTargetArns) {
            assessmentTargetArns(Arrays.asList(assessmentTargetArns));
            return this;
        }

        public final void setAssessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = ListReturnedArnListCopier.copy(assessmentTargetArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssessmentTargetsResponse build() {
            return new ListAssessmentTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
