/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an Amazon Inspector assessment template. This data type is used as the response element in
 * the <a>DescribeAssessmentTemplates</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentTemplate.Builder, AssessmentTemplate> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AssessmentTemplate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssessmentTemplate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ASSESSMENT_TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentTargetArn").getter(getter(AssessmentTemplate::assessmentTargetArn))
            .setter(setter(Builder::assessmentTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArn").build())
            .build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("durationInSeconds").getter(getter(AssessmentTemplate::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInSeconds").build()).build();

    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("rulesPackageArns")
            .getter(getter(AssessmentTemplate::rulesPackageArns))
            .setter(setter(Builder::rulesPackageArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attribute>> USER_ATTRIBUTES_FOR_FINDINGS_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .memberName("userAttributesForFindings")
            .getter(getter(AssessmentTemplate::userAttributesForFindings))
            .setter(setter(Builder::userAttributesForFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttributesForFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_ASSESSMENT_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastAssessmentRunArn").getter(getter(AssessmentTemplate::lastAssessmentRunArn))
            .setter(setter(Builder::lastAssessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAssessmentRunArn").build())
            .build();

    private static final SdkField<Integer> ASSESSMENT_RUN_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("assessmentRunCount").getter(getter(AssessmentTemplate::assessmentRunCount))
            .setter(setter(Builder::assessmentRunCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunCount").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AssessmentTemplate::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            ASSESSMENT_TARGET_ARN_FIELD, DURATION_IN_SECONDS_FIELD, RULES_PACKAGE_ARNS_FIELD, USER_ATTRIBUTES_FOR_FINDINGS_FIELD,
            LAST_ASSESSMENT_RUN_ARN_FIELD, ASSESSMENT_RUN_COUNT_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String assessmentTargetArn;

    private final Integer durationInSeconds;

    private final List<String> rulesPackageArns;

    private final List<Attribute> userAttributesForFindings;

    private final String lastAssessmentRunArn;

    private final Integer assessmentRunCount;

    private final Instant createdAt;

    private AssessmentTemplate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.assessmentTargetArn = builder.assessmentTargetArn;
        this.durationInSeconds = builder.durationInSeconds;
        this.rulesPackageArns = builder.rulesPackageArns;
        this.userAttributesForFindings = builder.userAttributesForFindings;
        this.lastAssessmentRunArn = builder.lastAssessmentRunArn;
        this.assessmentRunCount = builder.assessmentRunCount;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The ARN of the assessment template.
     * </p>
     * 
     * @return The ARN of the assessment template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the assessment template.
     * </p>
     * 
     * @return The name of the assessment template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the assessment target that corresponds to this assessment template.
     * </p>
     * 
     * @return The ARN of the assessment target that corresponds to this assessment template.
     */
    public final String assessmentTargetArn() {
        return assessmentTargetArn;
    }

    /**
     * <p>
     * The duration in seconds specified for this assessment template. The default value is 3600 seconds (one hour). The
     * maximum value is 86400 seconds (one day).
     * </p>
     * 
     * @return The duration in seconds specified for this assessment template. The default value is 3600 seconds (one
     *         hour). The maximum value is 86400 seconds (one day).
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * Returns true if the RulesPackageArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRulesPackageArns() {
        return rulesPackageArns != null && !(rulesPackageArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules packages that are specified for this assessment template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRulesPackageArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rules packages that are specified for this assessment template.
     */
    public final List<String> rulesPackageArns() {
        return rulesPackageArns;
    }

    /**
     * Returns true if the UserAttributesForFindings property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUserAttributesForFindings() {
        return userAttributesForFindings != null && !(userAttributesForFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user-defined attributes that are assigned to every generated finding from the assessment run that uses this
     * assessment template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserAttributesForFindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The user-defined attributes that are assigned to every generated finding from the assessment run that
     *         uses this assessment template.
     */
    public final List<Attribute> userAttributesForFindings() {
        return userAttributesForFindings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the most recent assessment run associated with this assessment template. This
     * value exists only when the value of assessmentRunCount is greaterpa than zero.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the most recent assessment run associated with this assessment
     *         template. This value exists only when the value of assessmentRunCount is greaterpa than zero.
     */
    public final String lastAssessmentRunArn() {
        return lastAssessmentRunArn;
    }

    /**
     * <p>
     * The number of existing assessment runs associated with this assessment template. This value can be zero or a
     * positive integer.
     * </p>
     * 
     * @return The number of existing assessment runs associated with this assessment template. This value can be zero
     *         or a positive integer.
     */
    public final Integer assessmentRunCount() {
        return assessmentRunCount;
    }

    /**
     * <p>
     * The time at which the assessment template is created.
     * </p>
     * 
     * @return The time at which the assessment template is created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasRulesPackageArns() ? rulesPackageArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAttributesForFindings() ? userAttributesForFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastAssessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunCount());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentTemplate)) {
            return false;
        }
        AssessmentTemplate other = (AssessmentTemplate) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(assessmentTargetArn(), other.assessmentTargetArn())
                && Objects.equals(durationInSeconds(), other.durationInSeconds())
                && hasRulesPackageArns() == other.hasRulesPackageArns()
                && Objects.equals(rulesPackageArns(), other.rulesPackageArns())
                && hasUserAttributesForFindings() == other.hasUserAttributesForFindings()
                && Objects.equals(userAttributesForFindings(), other.userAttributesForFindings())
                && Objects.equals(lastAssessmentRunArn(), other.lastAssessmentRunArn())
                && Objects.equals(assessmentRunCount(), other.assessmentRunCount())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentTemplate").add("Arn", arn()).add("Name", name())
                .add("AssessmentTargetArn", assessmentTargetArn()).add("DurationInSeconds", durationInSeconds())
                .add("RulesPackageArns", hasRulesPackageArns() ? rulesPackageArns() : null)
                .add("UserAttributesForFindings", hasUserAttributesForFindings() ? userAttributesForFindings() : null)
                .add("LastAssessmentRunArn", lastAssessmentRunArn()).add("AssessmentRunCount", assessmentRunCount())
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "assessmentTargetArn":
            return Optional.ofNullable(clazz.cast(assessmentTargetArn()));
        case "durationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "rulesPackageArns":
            return Optional.ofNullable(clazz.cast(rulesPackageArns()));
        case "userAttributesForFindings":
            return Optional.ofNullable(clazz.cast(userAttributesForFindings()));
        case "lastAssessmentRunArn":
            return Optional.ofNullable(clazz.cast(lastAssessmentRunArn()));
        case "assessmentRunCount":
            return Optional.ofNullable(clazz.cast(assessmentRunCount()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentTemplate, T> g) {
        return obj -> g.apply((AssessmentTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentTemplate> {
        /**
         * <p>
         * The ARN of the assessment template.
         * </p>
         * 
         * @param arn
         *        The ARN of the assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the assessment template.
         * </p>
         * 
         * @param name
         *        The name of the assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the assessment target that corresponds to this assessment template.
         * </p>
         * 
         * @param assessmentTargetArn
         *        The ARN of the assessment target that corresponds to this assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargetArn(String assessmentTargetArn);

        /**
         * <p>
         * The duration in seconds specified for this assessment template. The default value is 3600 seconds (one hour).
         * The maximum value is 86400 seconds (one day).
         * </p>
         * 
         * @param durationInSeconds
         *        The duration in seconds specified for this assessment template. The default value is 3600 seconds (one
         *        hour). The maximum value is 86400 seconds (one day).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * The rules packages that are specified for this assessment template.
         * </p>
         * 
         * @param rulesPackageArns
         *        The rules packages that are specified for this assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(Collection<String> rulesPackageArns);

        /**
         * <p>
         * The rules packages that are specified for this assessment template.
         * </p>
         * 
         * @param rulesPackageArns
         *        The rules packages that are specified for this assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(String... rulesPackageArns);

        /**
         * <p>
         * The user-defined attributes that are assigned to every generated finding from the assessment run that uses
         * this assessment template.
         * </p>
         * 
         * @param userAttributesForFindings
         *        The user-defined attributes that are assigned to every generated finding from the assessment run that
         *        uses this assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributesForFindings(Collection<Attribute> userAttributesForFindings);

        /**
         * <p>
         * The user-defined attributes that are assigned to every generated finding from the assessment run that uses
         * this assessment template.
         * </p>
         * 
         * @param userAttributesForFindings
         *        The user-defined attributes that are assigned to every generated finding from the assessment run that
         *        uses this assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributesForFindings(Attribute... userAttributesForFindings);

        /**
         * <p>
         * The user-defined attributes that are assigned to every generated finding from the assessment run that uses
         * this assessment template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #userAttributesForFindings(List<Attribute>)}.
         * 
         * @param userAttributesForFindings
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAttributesForFindings(List<Attribute>)
         */
        Builder userAttributesForFindings(Consumer<Attribute.Builder>... userAttributesForFindings);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the most recent assessment run associated with this assessment template.
         * This value exists only when the value of assessmentRunCount is greaterpa than zero.
         * </p>
         * 
         * @param lastAssessmentRunArn
         *        The Amazon Resource Name (ARN) of the most recent assessment run associated with this assessment
         *        template. This value exists only when the value of assessmentRunCount is greaterpa than zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAssessmentRunArn(String lastAssessmentRunArn);

        /**
         * <p>
         * The number of existing assessment runs associated with this assessment template. This value can be zero or a
         * positive integer.
         * </p>
         * 
         * @param assessmentRunCount
         *        The number of existing assessment runs associated with this assessment template. This value can be
         *        zero or a positive integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunCount(Integer assessmentRunCount);

        /**
         * <p>
         * The time at which the assessment template is created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the assessment template is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String assessmentTargetArn;

        private Integer durationInSeconds;

        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();

        private List<Attribute> userAttributesForFindings = DefaultSdkAutoConstructList.getInstance();

        private String lastAssessmentRunArn;

        private Integer assessmentRunCount;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentTemplate model) {
            arn(model.arn);
            name(model.name);
            assessmentTargetArn(model.assessmentTargetArn);
            durationInSeconds(model.durationInSeconds);
            rulesPackageArns(model.rulesPackageArns);
            userAttributesForFindings(model.userAttributesForFindings);
            lastAssessmentRunArn(model.lastAssessmentRunArn);
            assessmentRunCount(model.assessmentRunCount);
            createdAt(model.createdAt);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAssessmentTargetArn() {
            return assessmentTargetArn;
        }

        @Override
        public final Builder assessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
            return this;
        }

        public final void setAssessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        public final Collection<String> getRulesPackageArns() {
            if (rulesPackageArns instanceof SdkAutoConstructList) {
                return null;
            }
            return rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentTemplateRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String... rulesPackageArns) {
            rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentTemplateRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        public final Collection<Attribute.Builder> getUserAttributesForFindings() {
            if (userAttributesForFindings instanceof SdkAutoConstructList) {
                return null;
            }
            return userAttributesForFindings != null ? userAttributesForFindings.stream().map(Attribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributesForFindings(Collection<Attribute> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copy(userAttributesForFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Attribute... userAttributesForFindings) {
            userAttributesForFindings(Arrays.asList(userAttributesForFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Consumer<Attribute.Builder>... userAttributesForFindings) {
            userAttributesForFindings(Stream.of(userAttributesForFindings).map(c -> Attribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributesForFindings(Collection<Attribute.BuilderImpl> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copyFromBuilder(userAttributesForFindings);
        }

        public final String getLastAssessmentRunArn() {
            return lastAssessmentRunArn;
        }

        @Override
        public final Builder lastAssessmentRunArn(String lastAssessmentRunArn) {
            this.lastAssessmentRunArn = lastAssessmentRunArn;
            return this;
        }

        public final void setLastAssessmentRunArn(String lastAssessmentRunArn) {
            this.lastAssessmentRunArn = lastAssessmentRunArn;
        }

        public final Integer getAssessmentRunCount() {
            return assessmentRunCount;
        }

        @Override
        public final Builder assessmentRunCount(Integer assessmentRunCount) {
            this.assessmentRunCount = assessmentRunCount;
            return this;
        }

        public final void setAssessmentRunCount(Integer assessmentRunCount) {
            this.assessmentRunCount = assessmentRunCount;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public AssessmentTemplate build() {
            return new AssessmentTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
