/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ContainerDistributionConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfigurationListCopier;
import software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfigurationListCopier;
import software.amazon.awssdk.services.imagebuilder.model.LicenseConfigurationArnListCopier;
import software.amazon.awssdk.services.imagebuilder.model.S3ExportConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.SsmParameterConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.SsmParameterConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Distribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Distribution> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(Distribution.getter(Distribution::region)).setter(Distribution.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<AmiDistributionConfiguration> AMI_DISTRIBUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("amiDistributionConfiguration").getter(Distribution.getter(Distribution::amiDistributionConfiguration)).setter(Distribution.setter(Builder::amiDistributionConfiguration)).constructor(AmiDistributionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiDistributionConfiguration").build()}).build();
    private static final SdkField<ContainerDistributionConfiguration> CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerDistributionConfiguration").getter(Distribution.getter(Distribution::containerDistributionConfiguration)).setter(Distribution.setter(Builder::containerDistributionConfiguration)).constructor(ContainerDistributionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDistributionConfiguration").build()}).build();
    private static final SdkField<List<String>> LICENSE_CONFIGURATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenseConfigurationArns").getter(Distribution.getter(Distribution::licenseConfigurationArns)).setter(Distribution.setter(Builder::licenseConfigurationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseConfigurationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchTemplateConfiguration>> LAUNCH_TEMPLATE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("launchTemplateConfigurations").getter(Distribution.getter(Distribution::launchTemplateConfigurations)).setter(Distribution.setter(Builder::launchTemplateConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplateConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<S3ExportConfiguration> S3_EXPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3ExportConfiguration").getter(Distribution.getter(Distribution::s3ExportConfiguration)).setter(Distribution.setter(Builder::s3ExportConfiguration)).constructor(S3ExportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ExportConfiguration").build()}).build();
    private static final SdkField<List<FastLaunchConfiguration>> FAST_LAUNCH_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fastLaunchConfigurations").getter(Distribution.getter(Distribution::fastLaunchConfigurations)).setter(Distribution.setter(Builder::fastLaunchConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fastLaunchConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FastLaunchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SsmParameterConfiguration>> SSM_PARAMETER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ssmParameterConfigurations").getter(Distribution.getter(Distribution::ssmParameterConfigurations)).setter(Distribution.setter(Builder::ssmParameterConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmParameterConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SsmParameterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, AMI_DISTRIBUTION_CONFIGURATION_FIELD, CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD, LICENSE_CONFIGURATION_ARNS_FIELD, LAUNCH_TEMPLATE_CONFIGURATIONS_FIELD, S3_EXPORT_CONFIGURATION_FIELD, FAST_LAUNCH_CONFIGURATIONS_FIELD, SSM_PARAMETER_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Distribution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String region;
    private final AmiDistributionConfiguration amiDistributionConfiguration;
    private final ContainerDistributionConfiguration containerDistributionConfiguration;
    private final List<String> licenseConfigurationArns;
    private final List<LaunchTemplateConfiguration> launchTemplateConfigurations;
    private final S3ExportConfiguration s3ExportConfiguration;
    private final List<FastLaunchConfiguration> fastLaunchConfigurations;
    private final List<SsmParameterConfiguration> ssmParameterConfigurations;

    private Distribution(BuilderImpl builder) {
        this.region = builder.region;
        this.amiDistributionConfiguration = builder.amiDistributionConfiguration;
        this.containerDistributionConfiguration = builder.containerDistributionConfiguration;
        this.licenseConfigurationArns = builder.licenseConfigurationArns;
        this.launchTemplateConfigurations = builder.launchTemplateConfigurations;
        this.s3ExportConfiguration = builder.s3ExportConfiguration;
        this.fastLaunchConfigurations = builder.fastLaunchConfigurations;
        this.ssmParameterConfigurations = builder.ssmParameterConfigurations;
    }

    public final String region() {
        return this.region;
    }

    public final AmiDistributionConfiguration amiDistributionConfiguration() {
        return this.amiDistributionConfiguration;
    }

    public final ContainerDistributionConfiguration containerDistributionConfiguration() {
        return this.containerDistributionConfiguration;
    }

    public final boolean hasLicenseConfigurationArns() {
        return this.licenseConfigurationArns != null && !(this.licenseConfigurationArns instanceof SdkAutoConstructList);
    }

    public final List<String> licenseConfigurationArns() {
        return this.licenseConfigurationArns;
    }

    public final boolean hasLaunchTemplateConfigurations() {
        return this.launchTemplateConfigurations != null && !(this.launchTemplateConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateConfiguration> launchTemplateConfigurations() {
        return this.launchTemplateConfigurations;
    }

    public final S3ExportConfiguration s3ExportConfiguration() {
        return this.s3ExportConfiguration;
    }

    public final boolean hasFastLaunchConfigurations() {
        return this.fastLaunchConfigurations != null && !(this.fastLaunchConfigurations instanceof SdkAutoConstructList);
    }

    public final List<FastLaunchConfiguration> fastLaunchConfigurations() {
        return this.fastLaunchConfigurations;
    }

    public final boolean hasSsmParameterConfigurations() {
        return this.ssmParameterConfigurations != null && !(this.ssmParameterConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SsmParameterConfiguration> ssmParameterConfigurations() {
        return this.ssmParameterConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiDistributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerDistributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseConfigurationArns() ? this.licenseConfigurationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchTemplateConfigurations() ? this.launchTemplateConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFastLaunchConfigurations() ? this.fastLaunchConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSsmParameterConfigurations() ? this.ssmParameterConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Distribution)) {
            return false;
        }
        Distribution other = (Distribution)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.amiDistributionConfiguration(), other.amiDistributionConfiguration()) && Objects.equals(this.containerDistributionConfiguration(), other.containerDistributionConfiguration()) && this.hasLicenseConfigurationArns() == other.hasLicenseConfigurationArns() && Objects.equals(this.licenseConfigurationArns(), other.licenseConfigurationArns()) && this.hasLaunchTemplateConfigurations() == other.hasLaunchTemplateConfigurations() && Objects.equals(this.launchTemplateConfigurations(), other.launchTemplateConfigurations()) && Objects.equals(this.s3ExportConfiguration(), other.s3ExportConfiguration()) && this.hasFastLaunchConfigurations() == other.hasFastLaunchConfigurations() && Objects.equals(this.fastLaunchConfigurations(), other.fastLaunchConfigurations()) && this.hasSsmParameterConfigurations() == other.hasSsmParameterConfigurations() && Objects.equals(this.ssmParameterConfigurations(), other.ssmParameterConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"Distribution").add("Region", (Object)this.region()).add("AmiDistributionConfiguration", (Object)this.amiDistributionConfiguration()).add("ContainerDistributionConfiguration", (Object)this.containerDistributionConfiguration()).add("LicenseConfigurationArns", this.hasLicenseConfigurationArns() ? this.licenseConfigurationArns() : null).add("LaunchTemplateConfigurations", this.hasLaunchTemplateConfigurations() ? this.launchTemplateConfigurations() : null).add("S3ExportConfiguration", (Object)this.s3ExportConfiguration()).add("FastLaunchConfigurations", this.hasFastLaunchConfigurations() ? this.fastLaunchConfigurations() : null).add("SsmParameterConfigurations", this.hasSsmParameterConfigurations() ? this.ssmParameterConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "amiDistributionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.amiDistributionConfiguration()));
            }
            case "containerDistributionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.containerDistributionConfiguration()));
            }
            case "licenseConfigurationArns": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationArns()));
            }
            case "launchTemplateConfigurations": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateConfigurations()));
            }
            case "s3ExportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3ExportConfiguration()));
            }
            case "fastLaunchConfigurations": {
                return Optional.ofNullable(clazz.cast(this.fastLaunchConfigurations()));
            }
            case "ssmParameterConfigurations": {
                return Optional.ofNullable(clazz.cast(this.ssmParameterConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("region", REGION_FIELD);
        map.put("amiDistributionConfiguration", AMI_DISTRIBUTION_CONFIGURATION_FIELD);
        map.put("containerDistributionConfiguration", CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD);
        map.put("licenseConfigurationArns", LICENSE_CONFIGURATION_ARNS_FIELD);
        map.put("launchTemplateConfigurations", LAUNCH_TEMPLATE_CONFIGURATIONS_FIELD);
        map.put("s3ExportConfiguration", S3_EXPORT_CONFIGURATION_FIELD);
        map.put("fastLaunchConfigurations", FAST_LAUNCH_CONFIGURATIONS_FIELD);
        map.put("ssmParameterConfigurations", SSM_PARAMETER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Distribution, T> g) {
        return obj -> g.apply((Distribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private AmiDistributionConfiguration amiDistributionConfiguration;
        private ContainerDistributionConfiguration containerDistributionConfiguration;
        private List<String> licenseConfigurationArns = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplateConfiguration> launchTemplateConfigurations = DefaultSdkAutoConstructList.getInstance();
        private S3ExportConfiguration s3ExportConfiguration;
        private List<FastLaunchConfiguration> fastLaunchConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<SsmParameterConfiguration> ssmParameterConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Distribution model) {
            this.region(model.region);
            this.amiDistributionConfiguration(model.amiDistributionConfiguration);
            this.containerDistributionConfiguration(model.containerDistributionConfiguration);
            this.licenseConfigurationArns(model.licenseConfigurationArns);
            this.launchTemplateConfigurations(model.launchTemplateConfigurations);
            this.s3ExportConfiguration(model.s3ExportConfiguration);
            this.fastLaunchConfigurations(model.fastLaunchConfigurations);
            this.ssmParameterConfigurations(model.ssmParameterConfigurations);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final AmiDistributionConfiguration.Builder getAmiDistributionConfiguration() {
            return this.amiDistributionConfiguration != null ? this.amiDistributionConfiguration.toBuilder() : null;
        }

        public final void setAmiDistributionConfiguration(AmiDistributionConfiguration.BuilderImpl amiDistributionConfiguration) {
            this.amiDistributionConfiguration = amiDistributionConfiguration != null ? amiDistributionConfiguration.build() : null;
        }

        @Override
        public final Builder amiDistributionConfiguration(AmiDistributionConfiguration amiDistributionConfiguration) {
            this.amiDistributionConfiguration = amiDistributionConfiguration;
            return this;
        }

        public final ContainerDistributionConfiguration.Builder getContainerDistributionConfiguration() {
            return this.containerDistributionConfiguration != null ? this.containerDistributionConfiguration.toBuilder() : null;
        }

        public final void setContainerDistributionConfiguration(ContainerDistributionConfiguration.BuilderImpl containerDistributionConfiguration) {
            this.containerDistributionConfiguration = containerDistributionConfiguration != null ? containerDistributionConfiguration.build() : null;
        }

        @Override
        public final Builder containerDistributionConfiguration(ContainerDistributionConfiguration containerDistributionConfiguration) {
            this.containerDistributionConfiguration = containerDistributionConfiguration;
            return this;
        }

        public final Collection<String> getLicenseConfigurationArns() {
            if (this.licenseConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.licenseConfigurationArns;
        }

        public final void setLicenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = LicenseConfigurationArnListCopier.copy(licenseConfigurationArns);
        }

        @Override
        public final Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = LicenseConfigurationArnListCopier.copy(licenseConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationArns(String ... licenseConfigurationArns) {
            this.licenseConfigurationArns(Arrays.asList(licenseConfigurationArns));
            return this;
        }

        public final List<LaunchTemplateConfiguration.Builder> getLaunchTemplateConfigurations() {
            List<LaunchTemplateConfiguration.Builder> result = LaunchTemplateConfigurationListCopier.copyToBuilder(this.launchTemplateConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchTemplateConfigurations(Collection<LaunchTemplateConfiguration.BuilderImpl> launchTemplateConfigurations) {
            this.launchTemplateConfigurations = LaunchTemplateConfigurationListCopier.copyFromBuilder(launchTemplateConfigurations);
        }

        @Override
        public final Builder launchTemplateConfigurations(Collection<LaunchTemplateConfiguration> launchTemplateConfigurations) {
            this.launchTemplateConfigurations = LaunchTemplateConfigurationListCopier.copy(launchTemplateConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigurations(LaunchTemplateConfiguration ... launchTemplateConfigurations) {
            this.launchTemplateConfigurations(Arrays.asList(launchTemplateConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigurations(Consumer<LaunchTemplateConfiguration.Builder> ... launchTemplateConfigurations) {
            this.launchTemplateConfigurations(Stream.of(launchTemplateConfigurations).map(c -> (LaunchTemplateConfiguration)((LaunchTemplateConfiguration.Builder)LaunchTemplateConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final S3ExportConfiguration.Builder getS3ExportConfiguration() {
            return this.s3ExportConfiguration != null ? this.s3ExportConfiguration.toBuilder() : null;
        }

        public final void setS3ExportConfiguration(S3ExportConfiguration.BuilderImpl s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration != null ? s3ExportConfiguration.build() : null;
        }

        @Override
        public final Builder s3ExportConfiguration(S3ExportConfiguration s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration;
            return this;
        }

        public final List<FastLaunchConfiguration.Builder> getFastLaunchConfigurations() {
            List<FastLaunchConfiguration.Builder> result = FastLaunchConfigurationListCopier.copyToBuilder(this.fastLaunchConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFastLaunchConfigurations(Collection<FastLaunchConfiguration.BuilderImpl> fastLaunchConfigurations) {
            this.fastLaunchConfigurations = FastLaunchConfigurationListCopier.copyFromBuilder(fastLaunchConfigurations);
        }

        @Override
        public final Builder fastLaunchConfigurations(Collection<FastLaunchConfiguration> fastLaunchConfigurations) {
            this.fastLaunchConfigurations = FastLaunchConfigurationListCopier.copy(fastLaunchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastLaunchConfigurations(FastLaunchConfiguration ... fastLaunchConfigurations) {
            this.fastLaunchConfigurations(Arrays.asList(fastLaunchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastLaunchConfigurations(Consumer<FastLaunchConfiguration.Builder> ... fastLaunchConfigurations) {
            this.fastLaunchConfigurations(Stream.of(fastLaunchConfigurations).map(c -> (FastLaunchConfiguration)((FastLaunchConfiguration.Builder)FastLaunchConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SsmParameterConfiguration.Builder> getSsmParameterConfigurations() {
            List<SsmParameterConfiguration.Builder> result = SsmParameterConfigurationListCopier.copyToBuilder(this.ssmParameterConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSsmParameterConfigurations(Collection<SsmParameterConfiguration.BuilderImpl> ssmParameterConfigurations) {
            this.ssmParameterConfigurations = SsmParameterConfigurationListCopier.copyFromBuilder(ssmParameterConfigurations);
        }

        @Override
        public final Builder ssmParameterConfigurations(Collection<SsmParameterConfiguration> ssmParameterConfigurations) {
            this.ssmParameterConfigurations = SsmParameterConfigurationListCopier.copy(ssmParameterConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmParameterConfigurations(SsmParameterConfiguration ... ssmParameterConfigurations) {
            this.ssmParameterConfigurations(Arrays.asList(ssmParameterConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmParameterConfigurations(Consumer<SsmParameterConfiguration.Builder> ... ssmParameterConfigurations) {
            this.ssmParameterConfigurations(Stream.of(ssmParameterConfigurations).map(c -> (SsmParameterConfiguration)((SsmParameterConfiguration.Builder)SsmParameterConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Distribution build() {
            return new Distribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Distribution> {
        public Builder region(String var1);

        public Builder amiDistributionConfiguration(AmiDistributionConfiguration var1);

        default public Builder amiDistributionConfiguration(Consumer<AmiDistributionConfiguration.Builder> amiDistributionConfiguration) {
            return this.amiDistributionConfiguration((AmiDistributionConfiguration)((AmiDistributionConfiguration.Builder)AmiDistributionConfiguration.builder().applyMutation(amiDistributionConfiguration)).build());
        }

        public Builder containerDistributionConfiguration(ContainerDistributionConfiguration var1);

        default public Builder containerDistributionConfiguration(Consumer<ContainerDistributionConfiguration.Builder> containerDistributionConfiguration) {
            return this.containerDistributionConfiguration((ContainerDistributionConfiguration)((ContainerDistributionConfiguration.Builder)ContainerDistributionConfiguration.builder().applyMutation(containerDistributionConfiguration)).build());
        }

        public Builder licenseConfigurationArns(Collection<String> var1);

        public Builder licenseConfigurationArns(String ... var1);

        public Builder launchTemplateConfigurations(Collection<LaunchTemplateConfiguration> var1);

        public Builder launchTemplateConfigurations(LaunchTemplateConfiguration ... var1);

        public Builder launchTemplateConfigurations(Consumer<LaunchTemplateConfiguration.Builder> ... var1);

        public Builder s3ExportConfiguration(S3ExportConfiguration var1);

        default public Builder s3ExportConfiguration(Consumer<S3ExportConfiguration.Builder> s3ExportConfiguration) {
            return this.s3ExportConfiguration((S3ExportConfiguration)((S3ExportConfiguration.Builder)S3ExportConfiguration.builder().applyMutation(s3ExportConfiguration)).build());
        }

        public Builder fastLaunchConfigurations(Collection<FastLaunchConfiguration> var1);

        public Builder fastLaunchConfigurations(FastLaunchConfiguration ... var1);

        public Builder fastLaunchConfigurations(Consumer<FastLaunchConfiguration.Builder> ... var1);

        public Builder ssmParameterConfigurations(Collection<SsmParameterConfiguration> var1);

        public Builder ssmParameterConfigurations(SsmParameterConfiguration ... var1);

        public Builder ssmParameterConfigurations(Consumer<SsmParameterConfiguration.Builder> ... var1);
    }
}

