/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipesCopier;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicyResourceSelection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicyResourceSelection> {
    private static final SdkField<List<LifecyclePolicyResourceSelectionRecipe>> RECIPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recipes").getter(LifecyclePolicyResourceSelection.getter(LifecyclePolicyResourceSelection::recipes)).setter(LifecyclePolicyResourceSelection.setter(Builder::recipes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicyResourceSelectionRecipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAG_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tagMap").getter(LifecyclePolicyResourceSelection.getter(LifecyclePolicyResourceSelection::tagMap)).setter(LifecyclePolicyResourceSelection.setter(Builder::tagMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPES_FIELD, TAG_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LifecyclePolicyResourceSelection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<LifecyclePolicyResourceSelectionRecipe> recipes;
    private final Map<String, String> tagMap;

    private LifecyclePolicyResourceSelection(BuilderImpl builder) {
        this.recipes = builder.recipes;
        this.tagMap = builder.tagMap;
    }

    public final boolean hasRecipes() {
        return this.recipes != null && !(this.recipes instanceof SdkAutoConstructList);
    }

    public final List<LifecyclePolicyResourceSelectionRecipe> recipes() {
        return this.recipes;
    }

    public final boolean hasTagMap() {
        return this.tagMap != null && !(this.tagMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tagMap() {
        return this.tagMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecipes() ? this.recipes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagMap() ? this.tagMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyResourceSelection)) {
            return false;
        }
        LifecyclePolicyResourceSelection other = (LifecyclePolicyResourceSelection)obj;
        return this.hasRecipes() == other.hasRecipes() && Objects.equals(this.recipes(), other.recipes()) && this.hasTagMap() == other.hasTagMap() && Objects.equals(this.tagMap(), other.tagMap());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicyResourceSelection").add("Recipes", this.hasRecipes() ? this.recipes() : null).add("TagMap", this.hasTagMap() ? this.tagMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recipes": {
                return Optional.ofNullable(clazz.cast(this.recipes()));
            }
            case "tagMap": {
                return Optional.ofNullable(clazz.cast(this.tagMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recipes", RECIPES_FIELD);
        map.put("tagMap", TAG_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyResourceSelection, T> g) {
        return obj -> g.apply((LifecyclePolicyResourceSelection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LifecyclePolicyResourceSelectionRecipe> recipes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tagMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyResourceSelection model) {
            this.recipes(model.recipes);
            this.tagMap(model.tagMap);
        }

        public final List<LifecyclePolicyResourceSelectionRecipe.Builder> getRecipes() {
            List<LifecyclePolicyResourceSelectionRecipe.Builder> result = LifecyclePolicyResourceSelectionRecipesCopier.copyToBuilder(this.recipes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecipes(Collection<LifecyclePolicyResourceSelectionRecipe.BuilderImpl> recipes) {
            this.recipes = LifecyclePolicyResourceSelectionRecipesCopier.copyFromBuilder(recipes);
        }

        @Override
        public final Builder recipes(Collection<LifecyclePolicyResourceSelectionRecipe> recipes) {
            this.recipes = LifecyclePolicyResourceSelectionRecipesCopier.copy(recipes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipes(LifecyclePolicyResourceSelectionRecipe ... recipes) {
            this.recipes(Arrays.asList(recipes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipes(Consumer<LifecyclePolicyResourceSelectionRecipe.Builder> ... recipes) {
            this.recipes(Stream.of(recipes).map(c -> (LifecyclePolicyResourceSelectionRecipe)((LifecyclePolicyResourceSelectionRecipe.Builder)LifecyclePolicyResourceSelectionRecipe.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTagMap() {
            if (this.tagMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tagMap;
        }

        public final void setTagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
        }

        @Override
        public final Builder tagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
            return this;
        }

        public LifecyclePolicyResourceSelection build() {
            return new LifecyclePolicyResourceSelection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicyResourceSelection> {
        public Builder recipes(Collection<LifecyclePolicyResourceSelectionRecipe> var1);

        public Builder recipes(LifecyclePolicyResourceSelectionRecipe ... var1);

        public Builder recipes(Consumer<LifecyclePolicyResourceSelectionRecipe.Builder> ... var1);

        public Builder tagMap(Map<String, String> var1);
    }
}

