/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ComponentParameter;
import software.amazon.awssdk.services.imagebuilder.model.ComponentParameterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentConfiguration> {
    private static final SdkField<String> COMPONENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentArn").getter(ComponentConfiguration.getter(ComponentConfiguration::componentArn)).setter(ComponentConfiguration.setter(Builder::componentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentArn").build()}).build();
    private static final SdkField<List<ComponentParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(ComponentConfiguration.getter(ComponentConfiguration::parameters)).setter(ComponentConfiguration.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ARN_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String componentArn;
    private final List<ComponentParameter> parameters;

    private ComponentConfiguration(BuilderImpl builder) {
        this.componentArn = builder.componentArn;
        this.parameters = builder.parameters;
    }

    public final String componentArn() {
        return this.componentArn;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<ComponentParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentConfiguration)) {
            return false;
        }
        ComponentConfiguration other = (ComponentConfiguration)obj;
        return Objects.equals(this.componentArn(), other.componentArn()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentConfiguration").add("ComponentArn", (Object)this.componentArn()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentArn": {
                return Optional.ofNullable(clazz.cast(this.componentArn()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("componentArn", COMPONENT_ARN_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentConfiguration, T> g) {
        return obj -> g.apply((ComponentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentArn;
        private List<ComponentParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentConfiguration model) {
            this.componentArn(model.componentArn);
            this.parameters(model.parameters);
        }

        public final String getComponentArn() {
            return this.componentArn;
        }

        public final void setComponentArn(String componentArn) {
            this.componentArn = componentArn;
        }

        @Override
        public final Builder componentArn(String componentArn) {
            this.componentArn = componentArn;
            return this;
        }

        public final List<ComponentParameter.Builder> getParameters() {
            List<ComponentParameter.Builder> result = ComponentParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ComponentParameter.BuilderImpl> parameters) {
            this.parameters = ComponentParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ComponentParameter> parameters) {
            this.parameters = ComponentParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ComponentParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ComponentParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (ComponentParameter)((ComponentParameter.Builder)ComponentParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ComponentConfiguration build() {
            return new ComponentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentConfiguration> {
        public Builder componentArn(String var1);

        public Builder parameters(Collection<ComponentParameter> var1);

        public Builder parameters(ComponentParameter ... var1);

        public Builder parameters(Consumer<ComponentParameter.Builder> ... var1);
    }
}

