/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BuildType {
    USER_INITIATED("USER_INITIATED"),
    SCHEDULED("SCHEDULED"),
    IMPORT("IMPORT"),
    IMPORT_ISO("IMPORT_ISO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BuildType> VALUE_MAP;
    private final String value;

    private BuildType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BuildType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BuildType> knownValues() {
        EnumSet<BuildType> knownValues = EnumSet.allOf(BuildType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BuildType.class, BuildType::toString);
    }
}

