/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowExecutionsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListWorkflowExecutionsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ListWorkflowExecutionsResponse.getter(ListWorkflowExecutionsResponse::requestId)).setter(ListWorkflowExecutionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<WorkflowExecutionMetadata>> WORKFLOW_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workflowExecutions").getter(ListWorkflowExecutionsResponse.getter(ListWorkflowExecutionsResponse::workflowExecutions)).setter(ListWorkflowExecutionsResponse.setter(Builder::workflowExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowExecutionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageBuildVersionArn").getter(ListWorkflowExecutionsResponse.getter(ListWorkflowExecutionsResponse::imageBuildVersionArn)).setter(ListWorkflowExecutionsResponse.setter(Builder::imageBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(ListWorkflowExecutionsResponse.getter(ListWorkflowExecutionsResponse::message)).setter(ListWorkflowExecutionsResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkflowExecutionsResponse.getter(ListWorkflowExecutionsResponse::nextToken)).setter(ListWorkflowExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, WORKFLOW_EXECUTIONS_FIELD, IMAGE_BUILD_VERSION_ARN_FIELD, MESSAGE_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkflowExecutionsResponse.memberNameToFieldInitializer();
    private final String requestIdValue;
    private final List<WorkflowExecutionMetadata> workflowExecutions;
    private final String imageBuildVersionArn;
    private final String message;
    private final String nextToken;

    private ListWorkflowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.workflowExecutions = builder.workflowExecutions;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.message = builder.message;
        this.nextToken = builder.nextToken;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasWorkflowExecutions() {
        return this.workflowExecutions != null && !(this.workflowExecutions instanceof SdkAutoConstructList);
    }

    public final List<WorkflowExecutionMetadata> workflowExecutions() {
        return this.workflowExecutions;
    }

    public final String imageBuildVersionArn() {
        return this.imageBuildVersionArn;
    }

    public final String message() {
        return this.message;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflowExecutions() ? this.workflowExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowExecutionsResponse)) {
            return false;
        }
        ListWorkflowExecutionsResponse other = (ListWorkflowExecutionsResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && this.hasWorkflowExecutions() == other.hasWorkflowExecutions() && Objects.equals(this.workflowExecutions(), other.workflowExecutions()) && Objects.equals(this.imageBuildVersionArn(), other.imageBuildVersionArn()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowExecutionsResponse").add("RequestId", (Object)this.requestId()).add("WorkflowExecutions", this.hasWorkflowExecutions() ? this.workflowExecutions() : null).add("ImageBuildVersionArn", (Object)this.imageBuildVersionArn()).add("Message", (Object)this.message()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "workflowExecutions": {
                return Optional.ofNullable(clazz.cast(this.workflowExecutions()));
            }
            case "imageBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.imageBuildVersionArn()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("workflowExecutions", WORKFLOW_EXECUTIONS_FIELD);
        map.put("imageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowExecutionsResponse, T> g) {
        return obj -> g.apply((ListWorkflowExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<WorkflowExecutionMetadata> workflowExecutions = DefaultSdkAutoConstructList.getInstance();
        private String imageBuildVersionArn;
        private String message;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowExecutionsResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.workflowExecutions(model.workflowExecutions);
            this.imageBuildVersionArn(model.imageBuildVersionArn);
            this.message(model.message);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final List<WorkflowExecutionMetadata.Builder> getWorkflowExecutions() {
            List<WorkflowExecutionMetadata.Builder> result = WorkflowExecutionsListCopier.copyToBuilder(this.workflowExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflowExecutions(Collection<WorkflowExecutionMetadata.BuilderImpl> workflowExecutions) {
            this.workflowExecutions = WorkflowExecutionsListCopier.copyFromBuilder(workflowExecutions);
        }

        @Override
        public final Builder workflowExecutions(Collection<WorkflowExecutionMetadata> workflowExecutions) {
            this.workflowExecutions = WorkflowExecutionsListCopier.copy(workflowExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowExecutions(WorkflowExecutionMetadata ... workflowExecutions) {
            this.workflowExecutions(Arrays.asList(workflowExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowExecutions(Consumer<WorkflowExecutionMetadata.Builder> ... workflowExecutions) {
            this.workflowExecutions(Stream.of(workflowExecutions).map(c -> (WorkflowExecutionMetadata)((WorkflowExecutionMetadata.Builder)WorkflowExecutionMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageBuildVersionArn() {
            return this.imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkflowExecutionsResponse build() {
            return new ListWorkflowExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowExecutionsResponse> {
        public Builder requestId(String var1);

        public Builder workflowExecutions(Collection<WorkflowExecutionMetadata> var1);

        public Builder workflowExecutions(WorkflowExecutionMetadata ... var1);

        public Builder workflowExecutions(Consumer<WorkflowExecutionMetadata.Builder> ... var1);

        public Builder imageBuildVersionArn(String var1);

        public Builder message(String var1);

        public Builder nextToken(String var1);
    }
}

