/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowVersion;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowVersionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListWorkflowsResponse> {
    private static final SdkField<List<WorkflowVersion>> WORKFLOW_VERSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workflowVersionList").getter(ListWorkflowsResponse.getter(ListWorkflowsResponse::workflowVersionList)).setter(ListWorkflowsResponse.setter(Builder::workflowVersionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowVersionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkflowsResponse.getter(ListWorkflowsResponse::nextToken)).setter(ListWorkflowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_VERSION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("workflowVersionList", WORKFLOW_VERSION_LIST_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<WorkflowVersion> workflowVersionList;
    private final String nextToken;

    private ListWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.workflowVersionList = builder.workflowVersionList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkflowVersionList() {
        return this.workflowVersionList != null && !(this.workflowVersionList instanceof SdkAutoConstructList);
    }

    public final List<WorkflowVersion> workflowVersionList() {
        return this.workflowVersionList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflowVersionList() ? this.workflowVersionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowsResponse)) {
            return false;
        }
        ListWorkflowsResponse other = (ListWorkflowsResponse)((Object)obj);
        return this.hasWorkflowVersionList() == other.hasWorkflowVersionList() && Objects.equals(this.workflowVersionList(), other.workflowVersionList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowsResponse").add("WorkflowVersionList", this.hasWorkflowVersionList() ? this.workflowVersionList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowVersionList": {
                return Optional.ofNullable(clazz.cast(this.workflowVersionList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowsResponse, T> g) {
        return obj -> g.apply((ListWorkflowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private List<WorkflowVersion> workflowVersionList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowsResponse model) {
            super(model);
            this.workflowVersionList(model.workflowVersionList);
            this.nextToken(model.nextToken);
        }

        public final List<WorkflowVersion.Builder> getWorkflowVersionList() {
            List<WorkflowVersion.Builder> result = WorkflowVersionListCopier.copyToBuilder(this.workflowVersionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflowVersionList(Collection<WorkflowVersion.BuilderImpl> workflowVersionList) {
            this.workflowVersionList = WorkflowVersionListCopier.copyFromBuilder(workflowVersionList);
        }

        @Override
        public final Builder workflowVersionList(Collection<WorkflowVersion> workflowVersionList) {
            this.workflowVersionList = WorkflowVersionListCopier.copy(workflowVersionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowVersionList(WorkflowVersion ... workflowVersionList) {
            this.workflowVersionList(Arrays.asList(workflowVersionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowVersionList(Consumer<WorkflowVersion.Builder> ... workflowVersionList) {
            this.workflowVersionList(Stream.of(workflowVersionList).map(c -> (WorkflowVersion)((WorkflowVersion.Builder)WorkflowVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkflowsResponse build() {
            return new ListWorkflowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowsResponse> {
        public Builder workflowVersionList(Collection<WorkflowVersion> var1);

        public Builder workflowVersionList(WorkflowVersion ... var1);

        public Builder workflowVersionList(Consumer<WorkflowVersion.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

