/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Ownership {
    SELF("Self"),
    SHARED("Shared"),
    AMAZON("Amazon"),
    THIRD_PARTY("ThirdParty"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Ownership> VALUE_MAP;
    private final String value;

    private Ownership(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Ownership fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Ownership> knownValues() {
        EnumSet<Ownership> knownValues = EnumSet.allOf(Ownership.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Ownership.class, Ownership::toString);
    }
}

