/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLifecyclePolicyResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, CreateLifecyclePolicyResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateLifecyclePolicyResponse.getter(CreateLifecyclePolicyResponse::clientToken)).setter(CreateLifecyclePolicyResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> LIFECYCLE_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecyclePolicyArn").getter(CreateLifecyclePolicyResponse.getter(CreateLifecyclePolicyResponse::lifecyclePolicyArn)).setter(CreateLifecyclePolicyResponse.setter(Builder::lifecyclePolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, LIFECYCLE_POLICY_ARN_FIELD));
    private final String clientToken;
    private final String lifecyclePolicyArn;

    private CreateLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.lifecyclePolicyArn = builder.lifecyclePolicyArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String lifecyclePolicyArn() {
        return this.lifecyclePolicyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLifecyclePolicyResponse)) {
            return false;
        }
        CreateLifecyclePolicyResponse other = (CreateLifecyclePolicyResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.lifecyclePolicyArn(), other.lifecyclePolicyArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLifecyclePolicyResponse").add("ClientToken", (Object)this.clientToken()).add("LifecyclePolicyArn", (Object)this.lifecyclePolicyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "lifecyclePolicyArn": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((CreateLifecyclePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String clientToken;
        private String lifecyclePolicyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLifecyclePolicyResponse model) {
            super(model);
            this.clientToken(model.clientToken);
            this.lifecyclePolicyArn(model.lifecyclePolicyArn);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLifecyclePolicyArn() {
            return this.lifecyclePolicyArn;
        }

        public final void setLifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
        }

        @Override
        public final Builder lifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
            return this;
        }

        @Override
        public CreateLifecyclePolicyResponse build() {
            return new CreateLifecyclePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLifecyclePolicyResponse> {
        public Builder clientToken(String var1);

        public Builder lifecyclePolicyArn(String var1);
    }
}

