/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.DistributionConfigurationSummary;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse;

public class ListDistributionConfigurationsIterable
implements SdkIterable<ListDistributionConfigurationsResponse> {
    private final ImagebuilderClient client;
    private final ListDistributionConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDistributionConfigurationsIterable(ImagebuilderClient client, ListDistributionConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDistributionConfigurationsResponseFetcher();
    }

    public Iterator<ListDistributionConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DistributionConfigurationSummary> distributionConfigurationSummaryList() {
        Function<ListDistributionConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.distributionConfigurationSummaryList() != null) {
                return response.distributionConfigurationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDistributionConfigurationsResponseFetcher
    implements SyncPageFetcher<ListDistributionConfigurationsResponse> {
        private ListDistributionConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDistributionConfigurationsResponse nextPage(ListDistributionConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionConfigurationsIterable.this.client.listDistributionConfigurations(ListDistributionConfigurationsIterable.this.firstRequest);
            }
            return ListDistributionConfigurationsIterable.this.client.listDistributionConfigurations((ListDistributionConfigurationsRequest)((Object)ListDistributionConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

