/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ImageScanningConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImageRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, CreateImageRequest> {
    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageRecipeArn").getter(CreateImageRequest.getter(CreateImageRequest::imageRecipeArn)).setter(CreateImageRequest.setter(Builder::imageRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()}).build();
    private static final SdkField<String> CONTAINER_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerRecipeArn").getter(CreateImageRequest.getter(CreateImageRequest::containerRecipeArn)).setter(CreateImageRequest.setter(Builder::containerRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipeArn").build()}).build();
    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionConfigurationArn").getter(CreateImageRequest.getter(CreateImageRequest::distributionConfigurationArn)).setter(CreateImageRequest.setter(Builder::distributionConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn").build()}).build();
    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("infrastructureConfigurationArn").getter(CreateImageRequest.getter(CreateImageRequest::infrastructureConfigurationArn)).setter(CreateImageRequest.setter(Builder::infrastructureConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn").build()}).build();
    private static final SdkField<ImageTestsConfiguration> IMAGE_TESTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageTestsConfiguration").getter(CreateImageRequest.getter(CreateImageRequest::imageTestsConfiguration)).setter(CreateImageRequest.setter(Builder::imageTestsConfiguration)).constructor(ImageTestsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsConfiguration").build()}).build();
    private static final SdkField<Boolean> ENHANCED_IMAGE_METADATA_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enhancedImageMetadataEnabled").getter(CreateImageRequest.getter(CreateImageRequest::enhancedImageMetadataEnabled)).setter(CreateImageRequest.setter(Builder::enhancedImageMetadataEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedImageMetadataEnabled").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateImageRequest.getter(CreateImageRequest::tags)).setter(CreateImageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateImageRequest.getter(CreateImageRequest::clientToken)).setter(CreateImageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageScanningConfiguration").getter(CreateImageRequest.getter(CreateImageRequest::imageScanningConfiguration)).setter(CreateImageRequest.setter(Builder::imageScanningConfiguration)).constructor(ImageScanningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_RECIPE_ARN_FIELD, CONTAINER_RECIPE_ARN_FIELD, DISTRIBUTION_CONFIGURATION_ARN_FIELD, INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, IMAGE_TESTS_CONFIGURATION_FIELD, ENHANCED_IMAGE_METADATA_ENABLED_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD));
    private final String imageRecipeArn;
    private final String containerRecipeArn;
    private final String distributionConfigurationArn;
    private final String infrastructureConfigurationArn;
    private final ImageTestsConfiguration imageTestsConfiguration;
    private final Boolean enhancedImageMetadataEnabled;
    private final Map<String, String> tags;
    private final String clientToken;
    private final ImageScanningConfiguration imageScanningConfiguration;

    private CreateImageRequest(BuilderImpl builder) {
        super(builder);
        this.imageRecipeArn = builder.imageRecipeArn;
        this.containerRecipeArn = builder.containerRecipeArn;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.imageTestsConfiguration = builder.imageTestsConfiguration;
        this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
    }

    public final String imageRecipeArn() {
        return this.imageRecipeArn;
    }

    public final String containerRecipeArn() {
        return this.containerRecipeArn;
    }

    public final String distributionConfigurationArn() {
        return this.distributionConfigurationArn;
    }

    public final String infrastructureConfigurationArn() {
        return this.infrastructureConfigurationArn;
    }

    public final ImageTestsConfiguration imageTestsConfiguration() {
        return this.imageTestsConfiguration;
    }

    public final Boolean enhancedImageMetadataEnabled() {
        return this.enhancedImageMetadataEnabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ImageScanningConfiguration imageScanningConfiguration() {
        return this.imageScanningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTestsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedImageMetadataEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanningConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRequest)) {
            return false;
        }
        CreateImageRequest other = (CreateImageRequest)((Object)obj);
        return Objects.equals(this.imageRecipeArn(), other.imageRecipeArn()) && Objects.equals(this.containerRecipeArn(), other.containerRecipeArn()) && Objects.equals(this.distributionConfigurationArn(), other.distributionConfigurationArn()) && Objects.equals(this.infrastructureConfigurationArn(), other.infrastructureConfigurationArn()) && Objects.equals(this.imageTestsConfiguration(), other.imageTestsConfiguration()) && Objects.equals(this.enhancedImageMetadataEnabled(), other.enhancedImageMetadataEnabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.imageScanningConfiguration(), other.imageScanningConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImageRequest").add("ImageRecipeArn", (Object)this.imageRecipeArn()).add("ContainerRecipeArn", (Object)this.containerRecipeArn()).add("DistributionConfigurationArn", (Object)this.distributionConfigurationArn()).add("InfrastructureConfigurationArn", (Object)this.infrastructureConfigurationArn()).add("ImageTestsConfiguration", (Object)this.imageTestsConfiguration()).add("EnhancedImageMetadataEnabled", (Object)this.enhancedImageMetadataEnabled()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).add("ImageScanningConfiguration", (Object)this.imageScanningConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.imageRecipeArn()));
            }
            case "containerRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.containerRecipeArn()));
            }
            case "distributionConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.distributionConfigurationArn()));
            }
            case "infrastructureConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfigurationArn()));
            }
            case "imageTestsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageTestsConfiguration()));
            }
            case "enhancedImageMetadataEnabled": {
                return Optional.ofNullable(clazz.cast(this.enhancedImageMetadataEnabled()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "imageScanningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageScanningConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageRequest, T> g) {
        return obj -> g.apply((CreateImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String imageRecipeArn;
        private String containerRecipeArn;
        private String distributionConfigurationArn;
        private String infrastructureConfigurationArn;
        private ImageTestsConfiguration imageTestsConfiguration;
        private Boolean enhancedImageMetadataEnabled;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private ImageScanningConfiguration imageScanningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRequest model) {
            super(model);
            this.imageRecipeArn(model.imageRecipeArn);
            this.containerRecipeArn(model.containerRecipeArn);
            this.distributionConfigurationArn(model.distributionConfigurationArn);
            this.infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            this.imageTestsConfiguration(model.imageTestsConfiguration);
            this.enhancedImageMetadataEnabled(model.enhancedImageMetadataEnabled);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
            this.imageScanningConfiguration(model.imageScanningConfiguration);
        }

        public final String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final String getContainerRecipeArn() {
            return this.containerRecipeArn;
        }

        public final void setContainerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
        }

        @Override
        public final Builder containerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        public final String getDistributionConfigurationArn() {
            return this.distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return this.infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final ImageTestsConfiguration.Builder getImageTestsConfiguration() {
            return this.imageTestsConfiguration != null ? this.imageTestsConfiguration.toBuilder() : null;
        }

        public final void setImageTestsConfiguration(ImageTestsConfiguration.BuilderImpl imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration != null ? imageTestsConfiguration.build() : null;
        }

        @Override
        public final Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        public final Boolean getEnhancedImageMetadataEnabled() {
            return this.enhancedImageMetadataEnabled;
        }

        public final void setEnhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
        }

        @Override
        public final Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return this.imageScanningConfiguration != null ? this.imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageRequest build() {
            return new CreateImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImageRequest> {
        public Builder imageRecipeArn(String var1);

        public Builder containerRecipeArn(String var1);

        public Builder distributionConfigurationArn(String var1);

        public Builder infrastructureConfigurationArn(String var1);

        public Builder imageTestsConfiguration(ImageTestsConfiguration var1);

        default public Builder imageTestsConfiguration(Consumer<ImageTestsConfiguration.Builder> imageTestsConfiguration) {
            return this.imageTestsConfiguration((ImageTestsConfiguration)((ImageTestsConfiguration.Builder)ImageTestsConfiguration.builder().applyMutation(imageTestsConfiguration)).build());
        }

        public Builder enhancedImageMetadataEnabled(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder imageScanningConfiguration(ImageScanningConfiguration var1);

        default public Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return this.imageScanningConfiguration((ImageScanningConfiguration)((ImageScanningConfiguration.Builder)ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

