/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteImagePipelineRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<DeleteImagePipelineRequest.Builder, DeleteImagePipelineRequest> {
    private static final SdkField<String> IMAGE_PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imagePipelineArn").getter(getter(DeleteImagePipelineRequest::imagePipelineArn))
            .setter(setter(Builder::imagePipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("imagePipelineArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_PIPELINE_ARN_FIELD));

    private final String imagePipelineArn;

    private DeleteImagePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.imagePipelineArn = builder.imagePipelineArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image pipeline to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image pipeline to delete.
     */
    public final String imagePipelineArn() {
        return imagePipelineArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imagePipelineArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteImagePipelineRequest)) {
            return false;
        }
        DeleteImagePipelineRequest other = (DeleteImagePipelineRequest) obj;
        return Objects.equals(imagePipelineArn(), other.imagePipelineArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteImagePipelineRequest").add("ImagePipelineArn", imagePipelineArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imagePipelineArn":
            return Optional.ofNullable(clazz.cast(imagePipelineArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteImagePipelineRequest, T> g) {
        return obj -> g.apply((DeleteImagePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteImagePipelineRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image pipeline to delete.
         * </p>
         * 
         * @param imagePipelineArn
         *        The Amazon Resource Name (ARN) of the image pipeline to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePipelineArn(String imagePipelineArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String imagePipelineArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteImagePipelineRequest model) {
            super(model);
            imagePipelineArn(model.imagePipelineArn);
        }

        public final String getImagePipelineArn() {
            return imagePipelineArn;
        }

        public final void setImagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
        }

        @Override
        public final Builder imagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteImagePipelineRequest build() {
            return new DeleteImagePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
