/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ComponentConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ComponentConfigurationListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.imagebuilder.model.InstanceBlockDeviceMappingsCopier;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImageRecipeRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, CreateImageRecipeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::name)).setter(CreateImageRecipeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::description)).setter(CreateImageRecipeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("semanticVersion").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::semanticVersion)).setter(CreateImageRecipeRequest.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()}).build();
    private static final SdkField<List<ComponentConfiguration>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("components").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::components)).setter(CreateImageRecipeRequest.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PARENT_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentImage").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::parentImage)).setter(CreateImageRecipeRequest.setter(Builder::parentImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentImage").build()}).build();
    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockDeviceMappings").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::blockDeviceMappings)).setter(CreateImageRecipeRequest.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockDeviceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceBlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::tags)).setter(CreateImageRecipeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workingDirectory").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::workingDirectory)).setter(CreateImageRecipeRequest.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workingDirectory").build()}).build();
    private static final SdkField<AdditionalInstanceConfiguration> ADDITIONAL_INSTANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("additionalInstanceConfiguration").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::additionalInstanceConfiguration)).setter(CreateImageRecipeRequest.setter(Builder::additionalInstanceConfiguration)).constructor(AdditionalInstanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInstanceConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateImageRecipeRequest.getter(CreateImageRecipeRequest::clientToken)).setter(CreateImageRecipeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SEMANTIC_VERSION_FIELD, COMPONENTS_FIELD, PARENT_IMAGE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, TAGS_FIELD, WORKING_DIRECTORY_FIELD, ADDITIONAL_INSTANCE_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private final String name;
    private final String description;
    private final String semanticVersion;
    private final List<ComponentConfiguration> components;
    private final String parentImage;
    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private final Map<String, String> tags;
    private final String workingDirectory;
    private final AdditionalInstanceConfiguration additionalInstanceConfiguration;
    private final String clientToken;

    private CreateImageRecipeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.semanticVersion = builder.semanticVersion;
        this.components = builder.components;
        this.parentImage = builder.parentImage;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.tags = builder.tags;
        this.workingDirectory = builder.workingDirectory;
        this.additionalInstanceConfiguration = builder.additionalInstanceConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructList);
    }

    public final List<ComponentConfiguration> components() {
        return this.components;
    }

    public final String parentImage() {
        return this.parentImage;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final AdditionalInstanceConfiguration additionalInstanceConfiguration() {
        return this.additionalInstanceConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parentImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInstanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRecipeRequest)) {
            return false;
        }
        CreateImageRecipeRequest other = (CreateImageRecipeRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && Objects.equals(this.parentImage(), other.parentImage()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.additionalInstanceConfiguration(), other.additionalInstanceConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImageRecipeRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SemanticVersion", (Object)this.semanticVersion()).add("Components", this.hasComponents() ? this.components() : null).add("ParentImage", (Object)this.parentImage()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("Tags", this.hasTags() ? this.tags() : null).add("WorkingDirectory", (Object)this.workingDirectory()).add("AdditionalInstanceConfiguration", (Object)this.additionalInstanceConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "semanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "parentImage": {
                return Optional.ofNullable(clazz.cast(this.parentImage()));
            }
            case "blockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "additionalInstanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.additionalInstanceConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageRecipeRequest, T> g) {
        return obj -> g.apply((CreateImageRecipeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String semanticVersion;
        private List<ComponentConfiguration> components = DefaultSdkAutoConstructList.getInstance();
        private String parentImage;
        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workingDirectory;
        private AdditionalInstanceConfiguration additionalInstanceConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRecipeRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.semanticVersion(model.semanticVersion);
            this.components(model.components);
            this.parentImage(model.parentImage);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.tags(model.tags);
            this.workingDirectory(model.workingDirectory);
            this.additionalInstanceConfiguration(model.additionalInstanceConfiguration);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        @Transient
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final List<ComponentConfiguration.Builder> getComponents() {
            List<ComponentConfiguration.Builder> result = ComponentConfigurationListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<ComponentConfiguration.BuilderImpl> components) {
            this.components = ComponentConfigurationListCopier.copyFromBuilder(components);
        }

        @Override
        @Transient
        public final Builder components(Collection<ComponentConfiguration> components) {
            this.components = ComponentConfigurationListCopier.copy(components);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder components(ComponentConfiguration ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder components(Consumer<ComponentConfiguration.Builder> ... components) {
            this.components(Stream.of(components).map(c -> (ComponentConfiguration)((ComponentConfiguration.Builder)ComponentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getParentImage() {
            return this.parentImage;
        }

        public final void setParentImage(String parentImage) {
            this.parentImage = parentImage;
        }

        @Override
        @Transient
        public final Builder parentImage(String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        public final List<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<InstanceBlockDeviceMapping.Builder> result = InstanceBlockDeviceMappingsCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        @Transient
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (InstanceBlockDeviceMapping)((InstanceBlockDeviceMapping.Builder)InstanceBlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        @Transient
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final AdditionalInstanceConfiguration.Builder getAdditionalInstanceConfiguration() {
            return this.additionalInstanceConfiguration != null ? this.additionalInstanceConfiguration.toBuilder() : null;
        }

        public final void setAdditionalInstanceConfiguration(AdditionalInstanceConfiguration.BuilderImpl additionalInstanceConfiguration) {
            this.additionalInstanceConfiguration = additionalInstanceConfiguration != null ? additionalInstanceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder additionalInstanceConfiguration(AdditionalInstanceConfiguration additionalInstanceConfiguration) {
            this.additionalInstanceConfiguration = additionalInstanceConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageRecipeRequest build() {
            return new CreateImageRecipeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImageRecipeRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder semanticVersion(String var1);

        public Builder components(Collection<ComponentConfiguration> var1);

        public Builder components(ComponentConfiguration ... var1);

        public Builder components(Consumer<ComponentConfiguration.Builder> ... var1);

        public Builder parentImage(String var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder workingDirectory(String var1);

        public Builder additionalInstanceConfiguration(AdditionalInstanceConfiguration var1);

        default public Builder additionalInstanceConfiguration(Consumer<AdditionalInstanceConfiguration.Builder> additionalInstanceConfiguration) {
            return this.additionalInstanceConfiguration((AdditionalInstanceConfiguration)((AdditionalInstanceConfiguration.Builder)AdditionalInstanceConfiguration.builder().applyMutation(additionalInstanceConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

