/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.model.ImagePackage;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse;

public class ListImagePackagesIterable
implements SdkIterable<ListImagePackagesResponse> {
    private final ImagebuilderClient client;
    private final ListImagePackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImagePackagesIterable(ImagebuilderClient client, ListImagePackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImagePackagesResponseFetcher();
    }

    public Iterator<ListImagePackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImagePackage> imagePackageList() {
        Function<ListImagePackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imagePackageList() != null) {
                return response.imagePackageList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImagePackagesResponseFetcher
    implements SyncPageFetcher<ListImagePackagesResponse> {
        private ListImagePackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagePackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImagePackagesResponse nextPage(ListImagePackagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagePackagesIterable.this.client.listImagePackages(ListImagePackagesIterable.this.firstRequest);
            }
            return ListImagePackagesIterable.this.client.listImagePackages((ListImagePackagesRequest)((Object)ListImagePackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

