/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComponentFormat {
    SHELL("SHELL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComponentFormat> VALUE_MAP;
    private final String value;

    private ComponentFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComponentFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComponentFormat> knownValues() {
        EnumSet<ComponentFormat> knownValues = EnumSet.allOf(ComponentFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComponentFormat.class, ComponentFormat::toString);
    }
}

