/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImagePackage;

final class ImagePackageListCopier {
    ImagePackageListCopier() {
    }

    static List<ImagePackage> copy(Collection<? extends ImagePackage> imagePackageListParam) {
        Object list;
        if (imagePackageListParam == null || imagePackageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            imagePackageListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ImagePackage> copyFromBuilder(Collection<? extends ImagePackage.Builder> imagePackageListParam) {
        Object list;
        if (imagePackageListParam == null || imagePackageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            imagePackageListParam.forEach(entry -> {
                ImagePackage member = entry == null ? null : (ImagePackage)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ImagePackage.Builder> copyToBuilder(Collection<? extends ImagePackage> imagePackageListParam) {
        Object list;
        if (imagePackageListParam == null || imagePackageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            imagePackageListParam.forEach(entry -> {
                ImagePackage.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

