/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ContainerRepositoryService;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetContainerRepository
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetContainerRepository> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(TargetContainerRepository.getter(TargetContainerRepository::serviceAsString)).setter(TargetContainerRepository.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(TargetContainerRepository.getter(TargetContainerRepository::repositoryName)).setter(TargetContainerRepository.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, REPOSITORY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String service;
    private final String repositoryName;

    private TargetContainerRepository(BuilderImpl builder) {
        this.service = builder.service;
        this.repositoryName = builder.repositoryName;
    }

    public final ContainerRepositoryService service() {
        return ContainerRepositoryService.fromValue(this.service);
    }

    public final String serviceAsString() {
        return this.service;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetContainerRepository)) {
            return false;
        }
        TargetContainerRepository other = (TargetContainerRepository)obj;
        return Objects.equals(this.serviceAsString(), other.serviceAsString()) && Objects.equals(this.repositoryName(), other.repositoryName());
    }

    public final String toString() {
        return ToString.builder((String)"TargetContainerRepository").add("Service", (Object)this.serviceAsString()).add("RepositoryName", (Object)this.repositoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "service": {
                return Optional.ofNullable(clazz.cast(this.serviceAsString()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetContainerRepository, T> g) {
        return obj -> g.apply((TargetContainerRepository)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String service;
        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetContainerRepository model) {
            this.service(model.service);
            this.repositoryName(model.repositoryName);
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        @Transient
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        @Transient
        public final Builder service(ContainerRepositoryService service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public TargetContainerRepository build() {
            return new TargetContainerRepository(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetContainerRepository> {
        public Builder service(String var1);

        public Builder service(ContainerRepositoryService var1);

        public Builder repositoryName(String var1);
    }
}

