/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ComponentParameterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentParameterDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentParameterDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ComponentParameterDetail.getter(ComponentParameterDetail::name)).setter(ComponentParameterDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ComponentParameterDetail.getter(ComponentParameterDetail::type)).setter(ComponentParameterDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<String>> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("defaultValue").getter(ComponentParameterDetail.getter(ComponentParameterDetail::defaultValue)).setter(ComponentParameterDetail.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ComponentParameterDetail.getter(ComponentParameterDetail::description)).setter(ComponentParameterDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final List<String> defaultValue;
    private final String description;

    private ComponentParameterDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
    }

    public final String name() {
        return this.name;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasDefaultValue() {
        return this.defaultValue != null && !(this.defaultValue instanceof SdkAutoConstructList);
    }

    public final List<String> defaultValue() {
        return this.defaultValue;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultValue() ? this.defaultValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentParameterDetail)) {
            return false;
        }
        ComponentParameterDetail other = (ComponentParameterDetail)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type()) && this.hasDefaultValue() == other.hasDefaultValue() && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentParameterDetail").add("Name", (Object)this.name()).add("Type", (Object)this.type()).add("DefaultValue", this.hasDefaultValue() ? this.defaultValue() : null).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentParameterDetail, T> g) {
        return obj -> g.apply((ComponentParameterDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private List<String> defaultValue = DefaultSdkAutoConstructList.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentParameterDetail model) {
            this.name(model.name);
            this.type(model.type);
            this.defaultValue(model.defaultValue);
            this.description(model.description);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Collection<String> getDefaultValue() {
            if (this.defaultValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultValue;
        }

        public final void setDefaultValue(Collection<String> defaultValue) {
            this.defaultValue = ComponentParameterValueListCopier.copy(defaultValue);
        }

        @Override
        @Transient
        public final Builder defaultValue(Collection<String> defaultValue) {
            this.defaultValue = ComponentParameterValueListCopier.copy(defaultValue);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultValue(String ... defaultValue) {
            this.defaultValue(Arrays.asList(defaultValue));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ComponentParameterDetail build() {
            return new ComponentParameterDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentParameterDetail> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder defaultValue(Collection<String> var1);

        public Builder defaultValue(String ... var1);

        public Builder description(String var1);
    }
}

