/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.BuildType;
import software.amazon.awssdk.services.imagebuilder.model.ImageType;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageVersion> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ImageVersion.getter(ImageVersion::arn)).setter(ImageVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ImageVersion.getter(ImageVersion::name)).setter(ImageVersion.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ImageVersion.getter(ImageVersion::typeAsString)).setter(ImageVersion.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ImageVersion.getter(ImageVersion::version)).setter(ImageVersion.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(ImageVersion.getter(ImageVersion::platformAsString)).setter(ImageVersion.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osVersion").getter(ImageVersion.getter(ImageVersion::osVersion)).setter(ImageVersion.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(ImageVersion.getter(ImageVersion::owner)).setter(ImageVersion.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateCreated").getter(ImageVersion.getter(ImageVersion::dateCreated)).setter(ImageVersion.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<String> BUILD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildType").getter(ImageVersion.getter(ImageVersion::buildTypeAsString)).setter(ImageVersion.setter(Builder::buildType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, TYPE_FIELD, VERSION_FIELD, PLATFORM_FIELD, OS_VERSION_FIELD, OWNER_FIELD, DATE_CREATED_FIELD, BUILD_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String type;
    private final String version;
    private final String platform;
    private final String osVersion;
    private final String owner;
    private final String dateCreated;
    private final String buildType;

    private ImageVersion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.version = builder.version;
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.owner = builder.owner;
        this.dateCreated = builder.dateCreated;
        this.buildType = builder.buildType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final ImageType type() {
        return ImageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String version() {
        return this.version;
    }

    public final Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String osVersion() {
        return this.osVersion;
    }

    public final String owner() {
        return this.owner;
    }

    public final String dateCreated() {
        return this.dateCreated;
    }

    public final BuildType buildType() {
        return BuildType.fromValue(this.buildType);
    }

    public final String buildTypeAsString() {
        return this.buildType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageVersion)) {
            return false;
        }
        ImageVersion other = (ImageVersion)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.osVersion(), other.osVersion()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.buildTypeAsString(), other.buildTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImageVersion").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Version", (Object)this.version()).add("Platform", (Object)this.platformAsString()).add("OsVersion", (Object)this.osVersion()).add("Owner", (Object)this.owner()).add("DateCreated", (Object)this.dateCreated()).add("BuildType", (Object)this.buildTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "osVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersion()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "buildType": {
                return Optional.ofNullable(clazz.cast(this.buildTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageVersion, T> g) {
        return obj -> g.apply((ImageVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private String version;
        private String platform;
        private String osVersion;
        private String owner;
        private String dateCreated;
        private String buildType;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageVersion model) {
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.version(model.version);
            this.platform(model.platform);
            this.osVersion(model.osVersion);
            this.owner(model.owner);
            this.dateCreated(model.dateCreated);
            this.buildType(model.buildType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ImageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        @Transient
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        @Transient
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        @Transient
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final String getBuildType() {
            return this.buildType;
        }

        public final void setBuildType(String buildType) {
            this.buildType = buildType;
        }

        @Override
        @Transient
        public final Builder buildType(String buildType) {
            this.buildType = buildType;
            return this;
        }

        @Override
        @Transient
        public final Builder buildType(BuildType buildType) {
            this.buildType(buildType == null ? null : buildType.toString());
            return this;
        }

        public ImageVersion build() {
            return new ImageVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageVersion> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ImageType var1);

        public Builder version(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder osVersion(String var1);

        public Builder owner(String var1);

        public Builder dateCreated(String var1);

        public Builder buildType(String var1);

        public Builder buildType(BuildType var1);
    }
}

