/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for a launch permission. The launch permission modification request is sent to the <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">EC2
 * ModifyImageAttribute</a> API on behalf of the user for each Region they have selected to distribute the AMI. To make
 * an AMI public, set the launch permission authorized accounts to <code>all</code>. See the examples for making an AMI
 * public at <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">EC2
 * ModifyImageAttribute</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchPermissionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchPermissionConfiguration.Builder, LaunchPermissionConfiguration> {
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("userIds")
            .getter(getter(LaunchPermissionConfiguration::userIds))
            .setter(setter(Builder::userIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("userGroups")
            .getter(getter(LaunchPermissionConfiguration::userGroups))
            .setter(setter(Builder::userGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IDS_FIELD,
            USER_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> userIds;

    private final List<String> userGroups;

    private LaunchPermissionConfiguration(BuilderImpl builder) {
        this.userIds = builder.userIds;
        this.userGroups = builder.userGroups;
    }

    /**
     * Returns true if the UserIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserIds() {
        return userIds != null && !(userIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public final List<String> userIds() {
        return userIds;
    }

    /**
     * Returns true if the UserGroups property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserGroups() {
        return userGroups != null && !(userGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the group.
     */
    public final List<String> userGroups() {
        return userGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIds() ? userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroups() ? userGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermissionConfiguration)) {
            return false;
        }
        LaunchPermissionConfiguration other = (LaunchPermissionConfiguration) obj;
        return hasUserIds() == other.hasUserIds() && Objects.equals(userIds(), other.userIds())
                && hasUserGroups() == other.hasUserGroups() && Objects.equals(userGroups(), other.userGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchPermissionConfiguration").add("UserIds", hasUserIds() ? userIds() : null)
                .add("UserGroups", hasUserGroups() ? userGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userIds":
            return Optional.ofNullable(clazz.cast(userIds()));
        case "userGroups":
            return Optional.ofNullable(clazz.cast(userGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchPermissionConfiguration, T> g) {
        return obj -> g.apply((LaunchPermissionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchPermissionConfiguration> {
        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param userIds
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param userIds
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param userGroups
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<String> userGroups);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param userGroups
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(String... userGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermissionConfiguration model) {
            userIds(model.userIds);
            userGroups(model.userGroups);
        }

        public final Collection<String> getUserIds() {
            if (userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = AccountListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = AccountListCopier.copy(userIds);
        }

        public final Collection<String> getUserGroups() {
            if (userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroups;
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = StringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = StringListCopier.copy(userGroups);
        }

        @Override
        public LaunchPermissionConfiguration build() {
            return new LaunchPermissionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
