/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComponentRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<CreateComponentRequest.Builder, CreateComponentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateComponentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("semanticVersion").getter(getter(CreateComponentRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateComponentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CHANGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeDescription").getter(getter(CreateComponentRequest::changeDescription))
            .setter(setter(Builder::changeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeDescription").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(CreateComponentRequest::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<List<String>> SUPPORTED_OS_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedOsVersions")
            .getter(getter(CreateComponentRequest::supportedOsVersions))
            .setter(setter(Builder::supportedOsVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedOsVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("data")
            .getter(getter(CreateComponentRequest::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(CreateComponentRequest::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CreateComponentRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateComponentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateComponentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SEMANTIC_VERSION_FIELD, DESCRIPTION_FIELD, CHANGE_DESCRIPTION_FIELD, PLATFORM_FIELD, SUPPORTED_OS_VERSIONS_FIELD,
            DATA_FIELD, URI_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private final String name;

    private final String semanticVersion;

    private final String description;

    private final String changeDescription;

    private final String platform;

    private final List<String> supportedOsVersions;

    private final String data;

    private final String uri;

    private final String kmsKeyId;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.semanticVersion = builder.semanticVersion;
        this.description = builder.description;
        this.changeDescription = builder.changeDescription;
        this.platform = builder.platform;
        this.supportedOsVersions = builder.supportedOsVersions;
        this.data = builder.data;
        this.uri = builder.uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The semantic version of the component. This version follows the semantic version syntax. For example,
     * major.minor.patch. This could be versioned like software (2.0.1) or like a date (2019.12.01).
     * </p>
     * 
     * @return The semantic version of the component. This version follows the semantic version syntax. For example,
     *         major.minor.patch. This could be versioned like software (2.0.1) or like a date (2019.12.01).
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * The description of the component. Describes the contents of the component.
     * </p>
     * 
     * @return The description of the component. Describes the contents of the component.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The change description of the component. Describes what change has been made in this version, or what makes this
     * version different from other versions of this component.
     * </p>
     * 
     * @return The change description of the component. Describes what change has been made in this version, or what
     *         makes this version different from other versions of this component.
     */
    public final String changeDescription() {
        return changeDescription;
    }

    /**
     * <p>
     * The platform of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the component.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the component.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * Returns true if the SupportedOsVersions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedOsVersions() {
        return supportedOsVersions != null && !(supportedOsVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operating system (OS) version supported by the component. If the OS information is available, a prefix match
     * is performed against the parent image OS version during image recipe creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedOsVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The operating system (OS) version supported by the component. If the OS information is available, a
     *         prefix match is performed against the parent image OS version during image recipe creation.
     */
    public final List<String> supportedOsVersions() {
        return supportedOsVersions;
    }

    /**
     * <p>
     * The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be
     * used to specify the data within the component.
     * </p>
     * 
     * @return The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code>
     *         can be used to specify the data within the component.
     */
    public final String data() {
        return data;
    }

    /**
     * <p>
     * The uri of the component. Must be an S3 URL and the requester must have permission to access the S3 bucket. If
     * you use S3, you can specify component content up to your service quota. Either <code>data</code> or
     * <code>uri</code> can be used to specify the data within the component.
     * </p>
     * 
     * @return The uri of the component. Must be an S3 URL and the requester must have permission to access the S3
     *         bucket. If you use S3, you can specify component content up to your service quota. Either
     *         <code>data</code> or <code>uri</code> can be used to specify the data within the component.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The ID of the KMS key that should be used to encrypt this component.
     * </p>
     * 
     * @return The ID of the KMS key that should be used to encrypt this component.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags of the component.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The idempotency token of the component.
     * </p>
     * 
     * @return The idempotency token of the component.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(changeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedOsVersions() ? supportedOsVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentRequest)) {
            return false;
        }
        CreateComponentRequest other = (CreateComponentRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(description(), other.description())
                && Objects.equals(changeDescription(), other.changeDescription())
                && Objects.equals(platformAsString(), other.platformAsString())
                && hasSupportedOsVersions() == other.hasSupportedOsVersions()
                && Objects.equals(supportedOsVersions(), other.supportedOsVersions()) && Objects.equals(data(), other.data())
                && Objects.equals(uri(), other.uri()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComponentRequest").add("Name", name()).add("SemanticVersion", semanticVersion())
                .add("Description", description()).add("ChangeDescription", changeDescription())
                .add("Platform", platformAsString())
                .add("SupportedOsVersions", hasSupportedOsVersions() ? supportedOsVersions() : null).add("Data", data())
                .add("Uri", uri()).add("KmsKeyId", kmsKeyId()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "semanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "changeDescription":
            return Optional.ofNullable(clazz.cast(changeDescription()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "supportedOsVersions":
            return Optional.ofNullable(clazz.cast(supportedOsVersions()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentRequest, T> g) {
        return obj -> g.apply((CreateComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateComponentRequest> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param name
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The semantic version of the component. This version follows the semantic version syntax. For example,
         * major.minor.patch. This could be versioned like software (2.0.1) or like a date (2019.12.01).
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the component. This version follows the semantic version syntax. For example,
         *        major.minor.patch. This could be versioned like software (2.0.1) or like a date (2019.12.01).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * The description of the component. Describes the contents of the component.
         * </p>
         * 
         * @param description
         *        The description of the component. Describes the contents of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The change description of the component. Describes what change has been made in this version, or what makes
         * this version different from other versions of this component.
         * </p>
         * 
         * @param changeDescription
         *        The change description of the component. Describes what change has been made in this version, or what
         *        makes this version different from other versions of this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeDescription(String changeDescription);

        /**
         * <p>
         * The platform of the component.
         * </p>
         * 
         * @param platform
         *        The platform of the component.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the component.
         * </p>
         * 
         * @param platform
         *        The platform of the component.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The operating system (OS) version supported by the component. If the OS information is available, a prefix
         * match is performed against the parent image OS version during image recipe creation.
         * </p>
         * 
         * @param supportedOsVersions
         *        The operating system (OS) version supported by the component. If the OS information is available, a
         *        prefix match is performed against the parent image OS version during image recipe creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOsVersions(Collection<String> supportedOsVersions);

        /**
         * <p>
         * The operating system (OS) version supported by the component. If the OS information is available, a prefix
         * match is performed against the parent image OS version during image recipe creation.
         * </p>
         * 
         * @param supportedOsVersions
         *        The operating system (OS) version supported by the component. If the OS information is available, a
         *        prefix match is performed against the parent image OS version during image recipe creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOsVersions(String... supportedOsVersions);

        /**
         * <p>
         * The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can
         * be used to specify the data within the component.
         * </p>
         * 
         * @param data
         *        The data of the component. Used to specify the data inline. Either <code>data</code> or
         *        <code>uri</code> can be used to specify the data within the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);

        /**
         * <p>
         * The uri of the component. Must be an S3 URL and the requester must have permission to access the S3 bucket.
         * If you use S3, you can specify component content up to your service quota. Either <code>data</code> or
         * <code>uri</code> can be used to specify the data within the component.
         * </p>
         * 
         * @param uri
         *        The uri of the component. Must be an S3 URL and the requester must have permission to access the S3
         *        bucket. If you use S3, you can specify component content up to your service quota. Either
         *        <code>data</code> or <code>uri</code> can be used to specify the data within the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The ID of the KMS key that should be used to encrypt this component.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key that should be used to encrypt this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The tags of the component.
         * </p>
         * 
         * @param tags
         *        The tags of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The idempotency token of the component.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String name;

        private String semanticVersion;

        private String description;

        private String changeDescription;

        private String platform;

        private List<String> supportedOsVersions = DefaultSdkAutoConstructList.getInstance();

        private String data;

        private String uri;

        private String kmsKeyId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentRequest model) {
            super(model);
            name(model.name);
            semanticVersion(model.semanticVersion);
            description(model.description);
            changeDescription(model.changeDescription);
            platform(model.platform);
            supportedOsVersions(model.supportedOsVersions);
            data(model.data);
            uri(model.uri);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getChangeDescription() {
            return changeDescription;
        }

        @Override
        public final Builder changeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
            return this;
        }

        public final void setChangeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<String> getSupportedOsVersions() {
            if (supportedOsVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedOsVersions;
        }

        @Override
        public final Builder supportedOsVersions(Collection<String> supportedOsVersions) {
            this.supportedOsVersions = OsVersionListCopier.copy(supportedOsVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOsVersions(String... supportedOsVersions) {
            supportedOsVersions(Arrays.asList(supportedOsVersions));
            return this;
        }

        public final void setSupportedOsVersions(Collection<String> supportedOsVersions) {
            this.supportedOsVersions = OsVersionListCopier.copy(supportedOsVersions);
        }

        public final String getData() {
            return data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public final String getUri() {
            return uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentRequest build() {
            return new CreateComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
