/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.DistributionConfigurationSummary;
import software.amazon.awssdk.services.imagebuilder.model.DistributionConfigurationSummaryListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDistributionConfigurationsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListDistributionConfigurationsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ListDistributionConfigurationsResponse.getter(ListDistributionConfigurationsResponse::requestId)).setter(ListDistributionConfigurationsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<DistributionConfigurationSummary>> DISTRIBUTION_CONFIGURATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("distributionConfigurationSummaryList").getter(ListDistributionConfigurationsResponse.getter(ListDistributionConfigurationsResponse::distributionConfigurationSummaryList)).setter(ListDistributionConfigurationsResponse.setter(Builder::distributionConfigurationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DistributionConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDistributionConfigurationsResponse.getter(ListDistributionConfigurationsResponse::nextToken)).setter(ListDistributionConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, DISTRIBUTION_CONFIGURATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String requestIdValue;
    private final List<DistributionConfigurationSummary> distributionConfigurationSummaryList;
    private final String nextToken;

    private ListDistributionConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.distributionConfigurationSummaryList = builder.distributionConfigurationSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasDistributionConfigurationSummaryList() {
        return this.distributionConfigurationSummaryList != null && !(this.distributionConfigurationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<DistributionConfigurationSummary> distributionConfigurationSummaryList() {
        return this.distributionConfigurationSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistributionConfigurationSummaryList() ? this.distributionConfigurationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionConfigurationsResponse)) {
            return false;
        }
        ListDistributionConfigurationsResponse other = (ListDistributionConfigurationsResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && this.hasDistributionConfigurationSummaryList() == other.hasDistributionConfigurationSummaryList() && Objects.equals(this.distributionConfigurationSummaryList(), other.distributionConfigurationSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDistributionConfigurationsResponse").add("RequestId", (Object)this.requestId()).add("DistributionConfigurationSummaryList", this.hasDistributionConfigurationSummaryList() ? this.distributionConfigurationSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "distributionConfigurationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.distributionConfigurationSummaryList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionConfigurationsResponse, T> g) {
        return obj -> g.apply((ListDistributionConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<DistributionConfigurationSummary> distributionConfigurationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionConfigurationsResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.distributionConfigurationSummaryList(model.distributionConfigurationSummaryList);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final Collection<DistributionConfigurationSummary.Builder> getDistributionConfigurationSummaryList() {
            if (this.distributionConfigurationSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.distributionConfigurationSummaryList != null ? (Collection)this.distributionConfigurationSummaryList.stream().map(DistributionConfigurationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder distributionConfigurationSummaryList(Collection<DistributionConfigurationSummary> distributionConfigurationSummaryList) {
            this.distributionConfigurationSummaryList = DistributionConfigurationSummaryListCopier.copy(distributionConfigurationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributionConfigurationSummaryList(DistributionConfigurationSummary ... distributionConfigurationSummaryList) {
            this.distributionConfigurationSummaryList(Arrays.asList(distributionConfigurationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributionConfigurationSummaryList(Consumer<DistributionConfigurationSummary.Builder> ... distributionConfigurationSummaryList) {
            this.distributionConfigurationSummaryList(Stream.of(distributionConfigurationSummaryList).map(c -> (DistributionConfigurationSummary)((DistributionConfigurationSummary.Builder)DistributionConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDistributionConfigurationSummaryList(Collection<DistributionConfigurationSummary.BuilderImpl> distributionConfigurationSummaryList) {
            this.distributionConfigurationSummaryList = DistributionConfigurationSummaryListCopier.copyFromBuilder(distributionConfigurationSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDistributionConfigurationsResponse build() {
            return new ListDistributionConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDistributionConfigurationsResponse> {
        public Builder requestId(String var1);

        public Builder distributionConfigurationSummaryList(Collection<DistributionConfigurationSummary> var1);

        public Builder distributionConfigurationSummaryList(DistributionConfigurationSummary ... var1);

        public Builder distributionConfigurationSummaryList(Consumer<DistributionConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

