/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ContainerDistributionConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.LicenseConfigurationArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Distribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Distribution> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(Distribution.getter(Distribution::region)).setter(Distribution.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<AmiDistributionConfiguration> AMI_DISTRIBUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("amiDistributionConfiguration").getter(Distribution.getter(Distribution::amiDistributionConfiguration)).setter(Distribution.setter(Builder::amiDistributionConfiguration)).constructor(AmiDistributionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiDistributionConfiguration").build()}).build();
    private static final SdkField<ContainerDistributionConfiguration> CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerDistributionConfiguration").getter(Distribution.getter(Distribution::containerDistributionConfiguration)).setter(Distribution.setter(Builder::containerDistributionConfiguration)).constructor(ContainerDistributionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDistributionConfiguration").build()}).build();
    private static final SdkField<List<String>> LICENSE_CONFIGURATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenseConfigurationArns").getter(Distribution.getter(Distribution::licenseConfigurationArns)).setter(Distribution.setter(Builder::licenseConfigurationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseConfigurationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, AMI_DISTRIBUTION_CONFIGURATION_FIELD, CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD, LICENSE_CONFIGURATION_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String region;
    private final AmiDistributionConfiguration amiDistributionConfiguration;
    private final ContainerDistributionConfiguration containerDistributionConfiguration;
    private final List<String> licenseConfigurationArns;

    private Distribution(BuilderImpl builder) {
        this.region = builder.region;
        this.amiDistributionConfiguration = builder.amiDistributionConfiguration;
        this.containerDistributionConfiguration = builder.containerDistributionConfiguration;
        this.licenseConfigurationArns = builder.licenseConfigurationArns;
    }

    public final String region() {
        return this.region;
    }

    public final AmiDistributionConfiguration amiDistributionConfiguration() {
        return this.amiDistributionConfiguration;
    }

    public final ContainerDistributionConfiguration containerDistributionConfiguration() {
        return this.containerDistributionConfiguration;
    }

    public final boolean hasLicenseConfigurationArns() {
        return this.licenseConfigurationArns != null && !(this.licenseConfigurationArns instanceof SdkAutoConstructList);
    }

    public final List<String> licenseConfigurationArns() {
        return this.licenseConfigurationArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiDistributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerDistributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseConfigurationArns() ? this.licenseConfigurationArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Distribution)) {
            return false;
        }
        Distribution other = (Distribution)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.amiDistributionConfiguration(), other.amiDistributionConfiguration()) && Objects.equals(this.containerDistributionConfiguration(), other.containerDistributionConfiguration()) && this.hasLicenseConfigurationArns() == other.hasLicenseConfigurationArns() && Objects.equals(this.licenseConfigurationArns(), other.licenseConfigurationArns());
    }

    public final String toString() {
        return ToString.builder((String)"Distribution").add("Region", (Object)this.region()).add("AmiDistributionConfiguration", (Object)this.amiDistributionConfiguration()).add("ContainerDistributionConfiguration", (Object)this.containerDistributionConfiguration()).add("LicenseConfigurationArns", this.hasLicenseConfigurationArns() ? this.licenseConfigurationArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "amiDistributionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.amiDistributionConfiguration()));
            }
            case "containerDistributionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.containerDistributionConfiguration()));
            }
            case "licenseConfigurationArns": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Distribution, T> g) {
        return obj -> g.apply((Distribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private AmiDistributionConfiguration amiDistributionConfiguration;
        private ContainerDistributionConfiguration containerDistributionConfiguration;
        private List<String> licenseConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Distribution model) {
            this.region(model.region);
            this.amiDistributionConfiguration(model.amiDistributionConfiguration);
            this.containerDistributionConfiguration(model.containerDistributionConfiguration);
            this.licenseConfigurationArns(model.licenseConfigurationArns);
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final AmiDistributionConfiguration.Builder getAmiDistributionConfiguration() {
            return this.amiDistributionConfiguration != null ? this.amiDistributionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder amiDistributionConfiguration(AmiDistributionConfiguration amiDistributionConfiguration) {
            this.amiDistributionConfiguration = amiDistributionConfiguration;
            return this;
        }

        public final void setAmiDistributionConfiguration(AmiDistributionConfiguration.BuilderImpl amiDistributionConfiguration) {
            this.amiDistributionConfiguration = amiDistributionConfiguration != null ? amiDistributionConfiguration.build() : null;
        }

        public final ContainerDistributionConfiguration.Builder getContainerDistributionConfiguration() {
            return this.containerDistributionConfiguration != null ? this.containerDistributionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder containerDistributionConfiguration(ContainerDistributionConfiguration containerDistributionConfiguration) {
            this.containerDistributionConfiguration = containerDistributionConfiguration;
            return this;
        }

        public final void setContainerDistributionConfiguration(ContainerDistributionConfiguration.BuilderImpl containerDistributionConfiguration) {
            this.containerDistributionConfiguration = containerDistributionConfiguration != null ? containerDistributionConfiguration.build() : null;
        }

        public final Collection<String> getLicenseConfigurationArns() {
            if (this.licenseConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.licenseConfigurationArns;
        }

        @Override
        public final Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = LicenseConfigurationArnListCopier.copy(licenseConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationArns(String ... licenseConfigurationArns) {
            this.licenseConfigurationArns(Arrays.asList(licenseConfigurationArns));
            return this;
        }

        public final void setLicenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = LicenseConfigurationArnListCopier.copy(licenseConfigurationArns);
        }

        public Distribution build() {
            return new Distribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Distribution> {
        public Builder region(String var1);

        public Builder amiDistributionConfiguration(AmiDistributionConfiguration var1);

        default public Builder amiDistributionConfiguration(Consumer<AmiDistributionConfiguration.Builder> amiDistributionConfiguration) {
            return this.amiDistributionConfiguration((AmiDistributionConfiguration)((AmiDistributionConfiguration.Builder)AmiDistributionConfiguration.builder().applyMutation(amiDistributionConfiguration)).build());
        }

        public Builder containerDistributionConfiguration(ContainerDistributionConfiguration var1);

        default public Builder containerDistributionConfiguration(Consumer<ContainerDistributionConfiguration.Builder> containerDistributionConfiguration) {
            return this.containerDistributionConfiguration((ContainerDistributionConfiguration)((ContainerDistributionConfiguration.Builder)ContainerDistributionConfiguration.builder().applyMutation(containerDistributionConfiguration)).build());
        }

        public Builder licenseConfigurationArns(Collection<String> var1);

        public Builder licenseConfigurationArns(String ... var1);
    }
}

