/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse;

public class ListDistributionConfigurationsPublisher
implements SdkPublisher<ListDistributionConfigurationsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListDistributionConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDistributionConfigurationsPublisher(ImagebuilderAsyncClient client, ListDistributionConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDistributionConfigurationsPublisher(ImagebuilderAsyncClient client, ListDistributionConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDistributionConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDistributionConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDistributionConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListDistributionConfigurationsResponse> {
        private ListDistributionConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDistributionConfigurationsResponse> nextPage(ListDistributionConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionConfigurationsPublisher.this.client.listDistributionConfigurations(ListDistributionConfigurationsPublisher.this.firstRequest);
            }
            return ListDistributionConfigurationsPublisher.this.client.listDistributionConfigurations((ListDistributionConfigurationsRequest)((Object)ListDistributionConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

