/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceBlockDeviceMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceBlockDeviceMapping> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceName").getter(InstanceBlockDeviceMapping.getter(InstanceBlockDeviceMapping::deviceName)).setter(InstanceBlockDeviceMapping.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()}).build();
    private static final SdkField<EbsInstanceBlockDeviceSpecification> EBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ebs").getter(InstanceBlockDeviceMapping.getter(InstanceBlockDeviceMapping::ebs)).setter(InstanceBlockDeviceMapping.setter(Builder::ebs)).constructor(EbsInstanceBlockDeviceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebs").build()}).build();
    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualName").getter(InstanceBlockDeviceMapping.getter(InstanceBlockDeviceMapping::virtualName)).setter(InstanceBlockDeviceMapping.setter(Builder::virtualName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualName").build()}).build();
    private static final SdkField<String> NO_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("noDevice").getter(InstanceBlockDeviceMapping.getter(InstanceBlockDeviceMapping::noDevice)).setter(InstanceBlockDeviceMapping.setter(Builder::noDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noDevice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, EBS_FIELD, VIRTUAL_NAME_FIELD, NO_DEVICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceName;
    private final EbsInstanceBlockDeviceSpecification ebs;
    private final String virtualName;
    private final String noDevice;

    private InstanceBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.virtualName = builder.virtualName;
        this.noDevice = builder.noDevice;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public EbsInstanceBlockDeviceSpecification ebs() {
        return this.ebs;
    }

    public String virtualName() {
        return this.virtualName;
    }

    public String noDevice() {
        return this.noDevice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebs());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(this.noDevice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceBlockDeviceMapping)) {
            return false;
        }
        InstanceBlockDeviceMapping other = (InstanceBlockDeviceMapping)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.ebs(), other.ebs()) && Objects.equals(this.virtualName(), other.virtualName()) && Objects.equals(this.noDevice(), other.noDevice());
    }

    public String toString() {
        return ToString.builder((String)"InstanceBlockDeviceMapping").add("DeviceName", (Object)this.deviceName()).add("Ebs", (Object)this.ebs()).add("VirtualName", (Object)this.virtualName()).add("NoDevice", (Object)this.noDevice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "ebs": {
                return Optional.ofNullable(clazz.cast(this.ebs()));
            }
            case "virtualName": {
                return Optional.ofNullable(clazz.cast(this.virtualName()));
            }
            case "noDevice": {
                return Optional.ofNullable(clazz.cast(this.noDevice()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceBlockDeviceMapping, T> g) {
        return obj -> g.apply((InstanceBlockDeviceMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private EbsInstanceBlockDeviceSpecification ebs;
        private String virtualName;
        private String noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceBlockDeviceMapping model) {
            this.deviceName(model.deviceName);
            this.ebs(model.ebs);
            this.virtualName(model.virtualName);
            this.noDevice(model.noDevice);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final EbsInstanceBlockDeviceSpecification.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsInstanceBlockDeviceSpecification ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsInstanceBlockDeviceSpecification.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final String getNoDevice() {
            return this.noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public InstanceBlockDeviceMapping build() {
            return new InstanceBlockDeviceMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceBlockDeviceMapping> {
        public Builder deviceName(String var1);

        public Builder ebs(EbsInstanceBlockDeviceSpecification var1);

        default public Builder ebs(Consumer<EbsInstanceBlockDeviceSpecification.Builder> ebs) {
            return this.ebs((EbsInstanceBlockDeviceSpecification)((EbsInstanceBlockDeviceSpecification.Builder)EbsInstanceBlockDeviceSpecification.builder().applyMutation(ebs)).build());
        }

        public Builder virtualName(String var1);

        public Builder noDevice(String var1);
    }
}

