/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse;

public class ListComponentsIterable
implements SdkIterable<ListComponentsResponse> {
    private final ImagebuilderClient client;
    private final ListComponentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComponentsIterable(ImagebuilderClient client, ListComponentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListComponentsResponseFetcher();
    }

    public Iterator<ListComponentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListComponentsResponseFetcher
    implements SyncPageFetcher<ListComponentsResponse> {
        private ListComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComponentsResponse nextPage(ListComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListComponentsIterable.this.client.listComponents(ListComponentsIterable.this.firstRequest);
            }
            return ListComponentsIterable.this.client.listComponents((ListComponentsRequest)((Object)ListComponentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

